/*	$OpenBSD: ar9380reg.h,v 1.17 2012/06/10 21:23:36 kettenis Exp $	*/

/*-
 * Copyright (c) 2010 Damien Bergamini <damien.bergamini@free.fr>
 * Copyright (c) 2010 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define AR9380_MAX_CHAINS	3

#define AR9380_PHY_CCA_NOM_VAL_2GHZ		(-110)
#define AR9380_PHY_CCA_NOM_VAL_5GHZ		(-115)
#define AR9380_PHY_CCA_MIN_GOOD_VAL_2GHZ	(-125)
#define AR9380_PHY_CCA_MIN_GOOD_VAL_5GHZ	(-125)
#define AR9380_PHY_CCA_MAX_GOOD_VAL_2GHZ	( -95)
#define AR9380_PHY_CCA_MAX_GOOD_VAL_5GHZ	(-100)

/*
 * ROM layout used by AR9380.
 */
#define AR9380_NUM_5G_CAL_PIERS		8
#define AR9380_NUM_2G_CAL_PIERS		3
#define AR9380_NUM_5G_20_TARGET_POWERS	8
#define AR9380_NUM_5G_40_TARGET_POWERS	8
#define AR9380_NUM_2G_CCK_TARGET_POWERS	2
#define AR9380_NUM_2G_20_TARGET_POWERS	3
#define AR9380_NUM_2G_40_TARGET_POWERS	3
#define AR9380_NUM_CTLS_5G		9
#define AR9380_NUM_CTLS_2G		12
#define AR9380_NUM_BAND_EDGES_5G	8
#define AR9380_NUM_BAND_EDGES_2G	4
#define AR9380_NUM_PD_GAINS		4
#define AR9380_PD_GAINS_IN_MASK		4
#define AR9380_PD_GAIN_ICEPTS		5
#define AR9380_EEPROM_MODAL_SPURS	5
#define AR9380_CUSTOMER_DATA_SIZE	20

struct ar9380_cal_ctl_data_2g {
	uint8_t	ctlEdges[AR9380_NUM_BAND_EDGES_2G];
} __packed;

struct ar9380_cal_ctl_data_5g {
	uint8_t	ctlEdges[AR9380_NUM_BAND_EDGES_5G];
} __packed;

struct ar9380_base_eep_hdr {
	uint16_t	regDmn[2];
	uint8_t		txrxMask;
#define AR_EEP_TX_MASK_M	0xf0
#define AR_EEP_TX_MASK_S	4
#define AR_EEP_RX_MASK_M	0x0f
#define AR_EEP_RX_MASK_S	0

	uint8_t		opFlags;
#define AR_OPFLAGS_11A			0x01
#define AR_OPFLAGS_11G			0x02
#define AR_OPFLAGS_11N_5G40		0x04
#define AR_OPFLAGS_11N_2G40		0x08
#define AR_OPFLAGS_11N_5G20		0x10
#define AR_OPFLAGS_11N_2G20		0x20
/* Shortcut. */
#define AR_OPFLAGS_11N			0x3c

	uint8_t		eepMisc;
	uint8_t		rfSilent;
#define AR_EEP_RFSILENT_ENABLED		0x0001
#define AR_EEP_RFSILENT_POLARITY	0x0002

	uint8_t		blueToothOptions;
	uint8_t		deviceCap;
	uint8_t		deviceType;
	int8_t		pwrTableOffset;
	uint8_t		params_for_tuning_caps[2];
	uint8_t		featureEnable;
#define AR_EEP_TX_TEMP_COMP_EN		0x01
#define AR_EEP_TX_VOLT_COMP_EN		0x02
#define AR_EEP_FAST_CLOCK_EN		0x04
#define AR_EEP_DOUBLING_EN		0x08
#define AR_EEP_INTERNAL_REGULATOR	0x10
#define AR_EEP_PAPRD			0x20
#define AR_EEP_TUNING_CAPS		0x40

	uint8_t		miscConfiguration;
#define AR_EEP_DRIVE_STRENGTH		0x01
#define AR_EEP_CHAIN_MASK_REDUCE	0x08

	uint8_t		eepromWriteEnableGpio;
	uint8_t		wlanDisableGpio;
	uint8_t		wlanLedGpio;
	uint8_t		rxBandSelectGpio;
	uint8_t		txrxgain;
#define AR_EEP_TX_GAIN_M		0xf0
#define AR_EEP_TX_GAIN_S		4
#define AR_EEP_TX_GAIN_HIGH_OB_DB	1
#define AR_EEP_TX_GAIN_LOW_OB_DB	2
#define AR_EEP_TX_GAIN_HIGH_POWER	3
#define AR_EEP_RX_GAIN_M		0x0f
#define AR_EEP_RX_GAIN_S		0
#define AR_EEP_RX_GAIN_WO_XLNA		1

	uint32_t	swreg;
} __packed;

struct ar9380_modal_eep_header {
	uint32_t	antCtrlCommon;
	uint32_t	antCtrlCommon2;
	uint16_t	antCtrlChain[AR9380_MAX_CHAINS];
	uint8_t		xatten1DB[AR9380_MAX_CHAINS];
	uint8_t		xatten1Margin[AR9380_MAX_CHAINS];
	int8_t		tempSlope;
	int8_t		voltSlope;
	uint8_t		spurChans[AR9380_EEPROM_MODAL_SPURS];
	int8_t		noiseFloorThreshCh[AR9380_MAX_CHAINS];
	uint8_t		ob[AR9380_MAX_CHAINS];
	uint8_t		db_stage2[AR9380_MAX_CHAINS];
	uint8_t		db_stage3[AR9380_MAX_CHAINS];
	uint8_t		db_stage4[AR9380_MAX_CHAINS];
	uint8_t		xpaBiasLvl;
	uint8_t		txFrameToDataStart;
	uint8_t		txFrameToPaOn;
	uint8_t		txClip;
	int8_t		antennaGain;
	uint8_t		switchSettling;
	int8_t		adcDesiredSize;
	uint8_t		txEndToXpaOff;
	uint8_t		txEndToRxOn;
	uint8_t		txFrameToXpaOn;
	uint8_t		thresh62;
	uint32_t	papdRateMaskHt20;
	uint32_t	papdRateMaskHt40;
	uint8_t		futureModal[10];
} __packed;

struct ar9380_cal_data_per_freq_op_loop {
	int8_t	refPower;
	uint8_t	voltMeas;
	uint8_t	tempMeas;
	int8_t	rxNoisefloorCal;
	int8_t	rxNoisefloorPower;
	uint8_t	rxTempMeas;
} __packed;

struct ar9380_base_extension_1 {
	uint8_t	ant_div_control;
#define AR_EEP_ANT_DIV_CTRL_ALL_M	0x3f
#define AR_EEP_ANT_DIV_CTRL_ALL_S	0
#define AR_EEP_ANT_DIV_CTRL_ANT_DIV	0x40
#define AR_EEP_ANT_DIV_CTRL_FAST_DIV	0x80

	uint8_t	future[13];
} __packed;

struct ar9380_base_extension_2 {
	int8_t	tempSlopeLow;
	int8_t	tempSlopeHigh;
	uint8_t	xatten1DBLow[AR9380_MAX_CHAINS];
	uint8_t	xatten1MarginLow[AR9380_MAX_CHAINS];
	uint8_t	xatten1DBHigh[AR9380_MAX_CHAINS];
	uint8_t	xatten1MarginHigh[AR9380_MAX_CHAINS];
} __packed;

struct ar9380_eeprom {
	uint8_t	eepromVersion;
	uint8_t	templateVersion;
	uint8_t	macAddr[6];
	uint8_t	custData[AR9380_CUSTOMER_DATA_SIZE];
	struct	ar9380_base_eep_hdr baseEepHeader;
	struct	ar9380_modal_eep_header modalHeader2G;
	struct	ar9380_base_extension_1 base_ext1;
	uint8_t	calFreqPier2G[AR9380_NUM_2G_CAL_PIERS];
	struct	ar9380_cal_data_per_freq_op_loop
	    calPierData2G[AR9380_MAX_CHAINS][AR9380_NUM_2G_CAL_PIERS];
	uint8_t	calTargetFbinCck[AR9380_NUM_2G_CCK_TARGET_POWERS];
	uint8_t	calTargetFbin2G[AR9380_NUM_2G_20_TARGET_POWERS];
	uint8_t	calTargetFbin2GHT20[AR9380_NUM_2G_20_TARGET_POWERS];
	uint8_t	calTargetFbin2GHT40[AR9380_NUM_2G_40_TARGET_POWERS];
	struct	ar_cal_target_power_leg
	    calTargetPowerCck[AR9380_NUM_2G_CCK_TARGET_POWERS];
	struct	ar_cal_target_power_leg
	    calTargetPower2G[AR9380_NUM_2G_20_TARGET_POWERS];
	struct	ar_cal_target_power_ht
	    calTargetPower2GHT20[AR9380_NUM_2G_20_TARGET_POWERS];
	struct	ar_cal_target_power_ht
	    calTargetPower2GHT40[AR9380_NUM_2G_40_TARGET_POWERS];
	uint8_t	ctlIndex_2G[AR9380_NUM_CTLS_2G];
	uint8_t	ctl_freqbin_2G[AR9380_NUM_CTLS_2G][AR9380_NUM_BAND_EDGES_2G];
	struct	ar9380_cal_ctl_data_2g ctlPowerData_2G[AR9380_NUM_CTLS_2G];
	struct	ar9380_modal_eep_header modalHeader5G;
	struct	ar9380_base_extension_2 base_ext2;
	uint8_t	calFreqPier5G[AR9380_NUM_5G_CAL_PIERS];
	struct	ar9380_cal_data_per_freq_op_loop
	    calPierData5G[AR9380_MAX_CHAINS][AR9380_NUM_5G_CAL_PIERS];
	uint8_t	calTargetFbin5G[AR9380_NUM_5G_20_TARGET_POWERS];
	uint8_t	calTargetFbin5GHT20[AR9380_NUM_5G_20_TARGET_POWERS];
	uint8_t	calTargetFbin5GHT40[AR9380_NUM_5G_40_TARGET_POWERS];
	struct	ar_cal_target_power_leg
	    calTargetPower5G[AR9380_NUM_5G_20_TARGET_POWERS];
	struct	ar_cal_target_power_ht
	    calTargetPower5GHT20[AR9380_NUM_5G_20_TARGET_POWERS];
	struct	ar_cal_target_power_ht
	    calTargetPower5GHT40[AR9380_NUM_5G_40_TARGET_POWERS];
	uint8_t	ctlIndex_5G[AR9380_NUM_CTLS_5G];
	uint8_t	ctl_freqbin_5G[AR9380_NUM_CTLS_5G][AR9380_NUM_BAND_EDGES_5G];
	struct	ar9380_cal_ctl_data_5g ctlPowerData_5G[AR9380_NUM_CTLS_5G];
} __packed;

/*
 * ROM templates (little endian).
 */
static const uint8_t ar9380_def_rom[] = {
	0x02, 0x02, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0x00, 0x77, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x0c, 0x00, 0x03, 0x00, 0x08, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x22, 0x22, 0x02,
	0x00, 0x50, 0x01, 0x50, 0x01, 0x50, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x03, 0x00,
	0x2c, 0xe2, 0x00, 0x02, 0x0e, 0x1c, 0xe0, 0xe0, 0xf0, 0x0c,
	0xe0, 0xe0, 0xf0, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x89,
	0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xb8, 0x70, 0x89, 0xac,
	0x70, 0x89, 0xac, 0x70, 0x89, 0xac, 0x24, 0x24, 0x24, 0x24,
	0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x1c, 0x18, 0x20, 0x20,
	0x1c, 0x18, 0x20, 0x20, 0x1c, 0x18, 0x20, 0x20, 0x20, 0x20,
	0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14,
	0x20, 0x20, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14,
	0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x14,
	0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20,
	0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20,
	0x1c, 0x14, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20,
	0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x20, 0x20,
	0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14, 0x20, 0x20, 0x1c, 0x14,
	0x11, 0x12, 0x15, 0x17, 0x41, 0x42, 0x45, 0x47, 0x31, 0x32,
	0x35, 0x37, 0x70, 0x75, 0x9d, 0xa2, 0x70, 0x75, 0xa2, 0xff,
	0x70, 0x75, 0xa2, 0xff, 0x7a, 0x7f, 0x93, 0x98, 0x70, 0x75,
	0xac, 0xb8, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75, 0xac, 0x00,
	0x7a, 0x7f, 0x93, 0xa2, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75,
	0xac, 0x00, 0x70, 0x75, 0xac, 0x00, 0x7a, 0x7f, 0x93, 0xa2,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x7c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x00, 0x00, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x3c, 0x3c, 0x7c,
	0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x10, 0x01,
	0x00, 0x00, 0x22, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x0e, 0x0e, 0x03, 0x00, 0x2d, 0xe2, 0x00, 0x02, 0x0e,
	0x1c, 0x80, 0xc0, 0x80, 0x0c, 0x80, 0xc0, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4c, 0x54, 0x68, 0x78, 0x8c, 0xa0, 0xb9,
	0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x54, 0x68, 0x78, 0x8c,
	0xa0, 0xb9, 0xcd, 0x4c, 0x58, 0x68, 0x8c, 0xb4, 0xbd, 0xb9,
	0xcd, 0x4c, 0x58, 0x68, 0x8c, 0xb4, 0xbd, 0xb9, 0xcd, 0x14,
	0x14, 0x14, 0x0a, 0x14, 0x14, 0x14, 0x0a, 0x14, 0x14, 0x14,
	0x0a, 0x14, 0x14, 0x14, 0x0a, 0x14, 0x14, 0x14, 0x0a, 0x14,
	0x14, 0x14, 0x0a, 0x14, 0x14, 0x14, 0x0a, 0x14, 0x14, 0x14,
	0x0a, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14,
	0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a,
	0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a,
	0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a,
	0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14,
	0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a,
	0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a,
	0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a,
	0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14,
	0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a,
	0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a,
	0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x14, 0x14, 0x0a,
	0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00,
	0x00, 0x0a, 0x0a, 0x00, 0x00, 0x10, 0x16, 0x18, 0x40, 0x46,
	0x48, 0x30, 0x36, 0x38, 0x4c, 0x5c, 0x60, 0x8c, 0xa0, 0xb4,
	0xbd, 0xcd, 0x4c, 0x5c, 0x60, 0x8c, 0x90, 0xb4, 0xbd, 0xcd,
	0x4e, 0x56, 0x5e, 0x66, 0x8e, 0x96, 0xae, 0xbf, 0x4c, 0x50,
	0x5c, 0x68, 0x8c, 0xb4, 0xff, 0xff, 0x4c, 0x5c, 0x8c, 0xb4,
	0xff, 0xff, 0xff, 0xff, 0x4e, 0x5e, 0x66, 0x8e, 0x9e, 0xae,
	0xff, 0xff, 0x4c, 0x50, 0x54, 0x5c, 0x8c, 0xa0, 0xb4, 0xbd,
	0x4c, 0x5c, 0x68, 0x8c, 0x98, 0xb4, 0xbd, 0xcd, 0x4e, 0x56,
	0x5e, 0x8e, 0x96, 0xae, 0xbf, 0xc7, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c,
	0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c
};

static const uint8_t ar9380_def_rom_h112[] = {
	0x02, 0x03, 0x00, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x68, 0x31,
	0x31, 0x32, 0x2d, 0x32, 0x34, 0x31, 0x2d, 0x66, 0x30, 0x30,
	0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0x00, 0x77, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x0d, 0x00, 0x06, 0x00, 0x08, 0xff, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x44, 0x44, 0x04,
	0x00, 0x50, 0x01, 0x50, 0x01, 0x50, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x19, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x03, 0x00,
	0x2c, 0xe2, 0x00, 0x02, 0x0e, 0x1c, 0x80, 0xc0, 0x80, 0x00,
	0x80, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x89,
	0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xb8, 0x70, 0x89, 0xac,
	0x70, 0x89, 0xac, 0x70, 0x89, 0xac, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x22, 0x22,
	0x20, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x1e, 0x20, 0x20, 0x1e, 0x1c, 0x1c, 0x1c, 0x1c, 0x18,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x1e, 0x20, 0x20, 0x1e, 0x1c,
	0x1c, 0x1c, 0x1c, 0x18, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1e,
	0x20, 0x20, 0x1e, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x1e, 0x1e,
	0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e, 0x1c, 0x1a, 0x1a, 0x1a,
	0x1a, 0x16, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e,
	0x1c, 0x1a, 0x1a, 0x1a, 0x1a, 0x16, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1c, 0x1e, 0x1e, 0x1c, 0x1a, 0x1a, 0x1a, 0x1a, 0x16,
	0x11, 0x12, 0x15, 0x17, 0x41, 0x42, 0x45, 0x47, 0x31, 0x32,
	0x35, 0x37, 0x70, 0x75, 0x9d, 0xa2, 0x70, 0x75, 0xa2, 0xff,
	0x70, 0x75, 0xa2, 0xff, 0x7a, 0x7f, 0x93, 0x98, 0x70, 0x75,
	0xac, 0xb8, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75, 0xac, 0x00,
	0x7a, 0x7f, 0x93, 0xa2, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75,
	0xac, 0x00, 0x70, 0x75, 0xac, 0x00, 0x7a, 0x7f, 0x93, 0xa2,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x7c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x00, 0x00, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x3c, 0x3c, 0x7c,
	0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x20, 0x02,
	0x00, 0x00, 0x44, 0x44, 0x04, 0x00, 0x50, 0x01, 0x50, 0x01,
	0x50, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x0e, 0x0e, 0x03, 0x00, 0x2d, 0xe2, 0x00, 0x02, 0x0e,
	0x1c, 0xe0, 0xe0, 0xf0, 0x0c, 0xe0, 0xe0, 0xf0, 0x6c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28,
	0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4c, 0x54, 0x68, 0x78, 0x8c, 0xa0, 0xb4,
	0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x58, 0x68, 0x78, 0x8c,
	0xa0, 0xb4, 0xcd, 0x4c, 0x58, 0x68, 0x78, 0x8c, 0xb4, 0xbd,
	0xcd, 0x4c, 0x58, 0x68, 0x78, 0x8c, 0xb4, 0xbd, 0xcd, 0x1e,
	0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c,
	0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e,
	0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c,
	0x18, 0x1e, 0x1e, 0x1e, 0x1c, 0x18, 0x14, 0x1e, 0x1c, 0x18,
	0x14, 0x14, 0x14, 0x14, 0x10, 0x1e, 0x1e, 0x1e, 0x1c, 0x18,
	0x14, 0x1e, 0x1c, 0x18, 0x14, 0x14, 0x14, 0x14, 0x10, 0x1e,
	0x1e, 0x1e, 0x1a, 0x16, 0x12, 0x1e, 0x1a, 0x16, 0x12, 0x12,
	0x12, 0x12, 0x10, 0x1e, 0x1e, 0x1e, 0x1a, 0x16, 0x12, 0x1e,
	0x1a, 0x16, 0x12, 0x12, 0x12, 0x12, 0x10, 0x1e, 0x1e, 0x1e,
	0x18, 0x14, 0x10, 0x1e, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10,
	0x0e, 0x1e, 0x1e, 0x1e, 0x18, 0x14, 0x10, 0x1e, 0x18, 0x14,
	0x10, 0x10, 0x10, 0x10, 0x0e, 0x1e, 0x1e, 0x1e, 0x16, 0x12,
	0x0e, 0x1e, 0x16, 0x12, 0x0e, 0x0e, 0x0e, 0x0e, 0x0c, 0x1e,
	0x1e, 0x1e, 0x16, 0x12, 0x0e, 0x1e, 0x16, 0x12, 0x0e, 0x0e,
	0x0e, 0x0e, 0x0c, 0x1c, 0x1c, 0x1c, 0x1a, 0x16, 0x12, 0x1c,
	0x1a, 0x16, 0x12, 0x12, 0x12, 0x12, 0x0e, 0x1c, 0x1c, 0x1c,
	0x1a, 0x16, 0x12, 0x1c, 0x1a, 0x16, 0x12, 0x12, 0x12, 0x12,
	0x0e, 0x1c, 0x1c, 0x1c, 0x18, 0x14, 0x10, 0x1c, 0x18, 0x14,
	0x10, 0x10, 0x10, 0x10, 0x0c, 0x1c, 0x1c, 0x1c, 0x18, 0x14,
	0x10, 0x1c, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x1c,
	0x1c, 0x1c, 0x16, 0x12, 0x0e, 0x1c, 0x16, 0x12, 0x0e, 0x0e,
	0x0e, 0x0e, 0x0a, 0x1c, 0x1c, 0x1c, 0x16, 0x12, 0x0e, 0x1c,
	0x16, 0x12, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a, 0x1c, 0x1c, 0x1c,
	0x14, 0x10, 0x0c, 0x1c, 0x14, 0x10, 0x0c, 0x0c, 0x0c, 0x0c,
	0x08, 0x1c, 0x1c, 0x1c, 0x14, 0x10, 0x0c, 0x1c, 0x14, 0x10,
	0x0c, 0x0c, 0x0c, 0x0c, 0x08, 0x10, 0x16, 0x18, 0x40, 0x46,
	0x48, 0x30, 0x36, 0x38, 0x4c, 0x5c, 0x60, 0x8c, 0xa0, 0xb4,
	0xbd, 0xcd, 0x4c, 0x5c, 0x60, 0x8c, 0x90, 0xb4, 0xbd, 0xcd,
	0x4e, 0x56, 0x5e, 0x66, 0x8e, 0x96, 0xae, 0xbf, 0x4c, 0x50,
	0x5c, 0x68, 0x8c, 0xb4, 0xff, 0xff, 0x4c, 0x5c, 0x8c, 0xb4,
	0xff, 0xff, 0xff, 0xff, 0x4e, 0x5e, 0x66, 0x8e, 0x9e, 0xae,
	0xff, 0xff, 0x4c, 0x50, 0x54, 0x5c, 0x8c, 0xa0, 0xb4, 0xbd,
	0x4c, 0x5c, 0x68, 0x8c, 0x98, 0xb4, 0xbd, 0xcd, 0x4e, 0x56,
	0x5e, 0x8e, 0x96, 0xae, 0xbf, 0xc7, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c,
	0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c
};

static const uint8_t ar9380_def_rom_h116[] = {
	0x02, 0x04, 0x00, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x68, 0x31,
	0x31, 0x36, 0x2d, 0x30, 0x34, 0x31, 0x2d, 0x66, 0x30, 0x30,
	0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0x00, 0x33, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x0d, 0x00, 0x06, 0x00, 0x08, 0xff, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x44, 0x44, 0x04,
	0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1f, 0x1f, 0x1f,
	0x12, 0x12, 0x12, 0x19, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x03, 0x00,
	0x2c, 0xe2, 0x00, 0x02, 0x0e, 0x1c, 0x80, 0xc0, 0x80, 0x0c,
	0x80, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x89,
	0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xac, 0x70, 0x89, 0xac,
	0x70, 0x89, 0xac, 0x70, 0x89, 0xac, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x22, 0x22,
	0x20, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x1e, 0x20, 0x20, 0x1e, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x1e, 0x20, 0x20, 0x1e, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1e,
	0x20, 0x20, 0x1e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e,
	0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e, 0x1c, 0x1a, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e,
	0x1c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1c, 0x1e, 0x1e, 0x1c, 0x1a, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x15, 0x17, 0x41, 0x42, 0x45, 0x47, 0x31, 0x32,
	0x35, 0x37, 0x70, 0x75, 0x9d, 0xa2, 0x70, 0x75, 0xa2, 0xff,
	0x70, 0x75, 0xa2, 0xff, 0x7a, 0x7f, 0x93, 0x98, 0x70, 0x75,
	0xac, 0xb8, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75, 0xac, 0x00,
	0x7a, 0x7f, 0x93, 0xa2, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75,
	0xac, 0x00, 0x70, 0x75, 0xac, 0x00, 0x7a, 0x7f, 0x93, 0xa2,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x7c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x00, 0x00, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x3c, 0x3c, 0x7c,
	0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x20, 0x02,
	0x00, 0x00, 0x44, 0x44, 0x04, 0x00, 0x50, 0x01, 0x50, 0x01,
	0x50, 0x01, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x46, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x0e, 0x0e, 0x03, 0x00, 0x2d, 0xe2, 0x00, 0x02, 0x0e,
	0x1c, 0xe0, 0xe0, 0xf0, 0x0c, 0xe0, 0xe0, 0xf0, 0x6c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23,
	0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4c, 0x54, 0x68, 0x78, 0x8c, 0xa0, 0xb4,
	0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x58, 0x68, 0x78, 0x8c,
	0xa0, 0xb4, 0xcd, 0x4c, 0x58, 0x68, 0x78, 0x8c, 0xb4, 0xbd,
	0xcd, 0x4c, 0x58, 0x68, 0x78, 0x8c, 0xb4, 0xbd, 0xcd, 0x1e,
	0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c,
	0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e,
	0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c, 0x18, 0x1e, 0x1e, 0x1c,
	0x18, 0x1e, 0x1e, 0x1e, 0x1c, 0x18, 0x14, 0x1e, 0x1c, 0x18,
	0x14, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1c, 0x18,
	0x14, 0x1e, 0x1c, 0x18, 0x14, 0x00, 0x00, 0x00, 0x00, 0x1e,
	0x1e, 0x1e, 0x1a, 0x16, 0x12, 0x1e, 0x1a, 0x16, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1a, 0x16, 0x12, 0x1e,
	0x1a, 0x16, 0x12, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e,
	0x18, 0x14, 0x10, 0x1e, 0x18, 0x14, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x1e, 0x1e, 0x1e, 0x18, 0x14, 0x10, 0x1e, 0x18, 0x14,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x16, 0x12,
	0x0e, 0x1e, 0x16, 0x12, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x1e,
	0x1e, 0x1e, 0x16, 0x12, 0x0e, 0x1e, 0x16, 0x12, 0x0e, 0x00,
	0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1a, 0x16, 0x12, 0x1c,
	0x1a, 0x16, 0x12, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c,
	0x1a, 0x16, 0x12, 0x1c, 0x1a, 0x16, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0x1c, 0x1c, 0x18, 0x14, 0x10, 0x1c, 0x18, 0x14,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x18, 0x14,
	0x10, 0x1c, 0x18, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1c,
	0x1c, 0x1c, 0x16, 0x12, 0x0e, 0x1c, 0x16, 0x12, 0x0e, 0x00,
	0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x16, 0x12, 0x0e, 0x1c,
	0x16, 0x12, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c,
	0x14, 0x10, 0x0c, 0x1c, 0x14, 0x10, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0x1c, 0x1c, 0x14, 0x10, 0x0c, 0x1c, 0x14, 0x10,
	0x0c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x18, 0x40, 0x46,
	0x48, 0x30, 0x36, 0x38, 0x4c, 0x5c, 0x60, 0x8c, 0xa0, 0xb4,
	0xbd, 0xcd, 0x4c, 0x5c, 0x60, 0x8c, 0x90, 0xb4, 0xbd, 0xcd,
	0x4e, 0x56, 0x5e, 0x66, 0x8e, 0x96, 0xae, 0xbf, 0x4c, 0x50,
	0x5c, 0x68, 0x8c, 0xb4, 0xff, 0xff, 0x4c, 0x5c, 0x8c, 0xb4,
	0xff, 0xff, 0xff, 0xff, 0x4e, 0x5e, 0x66, 0x8e, 0x9e, 0xae,
	0xff, 0xff, 0x4c, 0x50, 0x54, 0x5c, 0x8c, 0xa0, 0xb4, 0xbd,
	0x4c, 0x5c, 0x68, 0x8c, 0x98, 0xb4, 0xbd, 0xcd, 0x4e, 0x56,
	0x5e, 0x8e, 0x96, 0xae, 0xbf, 0xc7, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c,
	0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c
};

static const uint8_t ar9380_def_rom_x112[] = {
	0x02, 0x05, 0x00, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x78, 0x31,
	0x31, 0x32, 0x2d, 0x30, 0x34, 0x31, 0x2d, 0x66, 0x30, 0x30,
	0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0x00, 0x77, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x0d, 0x00, 0x06, 0x00, 0x08, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x22, 0x22, 0x02,
	0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1b, 0x1b, 0x1b,
	0x15, 0x15, 0x15, 0x32, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x03, 0x00,
	0x2c, 0xe2, 0x00, 0x02, 0x0e, 0x1c, 0x80, 0xc0, 0x80, 0x0c,
	0x80, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x89,
	0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xac, 0x70, 0x89, 0xac,
	0x70, 0x89, 0xac, 0x70, 0x89, 0xac, 0x26, 0x26, 0x26, 0x26,
	0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x24, 0x22, 0x26, 0x26,
	0x24, 0x22, 0x26, 0x26, 0x22, 0x20, 0x24, 0x24, 0x24, 0x24,
	0x24, 0x22, 0x22, 0x20, 0x1e, 0x1c, 0x1c, 0x1c, 0x1c, 0x1a,
	0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x24, 0x22, 0x20, 0x1e,
	0x1e, 0x1e, 0x1c, 0x1a, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22,
	0x22, 0x20, 0x1e, 0x1c, 0x1c, 0x1c, 0x1c, 0x1a, 0x24, 0x24,
	0x24, 0x24, 0x22, 0x20, 0x20, 0x1e, 0x1c, 0x1a, 0x1a, 0x1a,
	0x1a, 0x18, 0x24, 0x24, 0x24, 0x24, 0x22, 0x20, 0x22, 0x20,
	0x1e, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x24, 0x24, 0x24, 0x24,
	0x22, 0x20, 0x20, 0x1e, 0x1c, 0x1a, 0x1a, 0x1a, 0x1a, 0x18,
	0x11, 0x12, 0x15, 0x17, 0x41, 0x42, 0x45, 0x47, 0x31, 0x32,
	0x35, 0x37, 0x70, 0x75, 0x9d, 0xa2, 0x70, 0x75, 0xa2, 0xff,
	0x70, 0x75, 0xa2, 0xff, 0x7a, 0x7f, 0x93, 0x98, 0x70, 0x75,
	0xac, 0xb8, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75, 0xac, 0x00,
	0x7a, 0x7f, 0x93, 0xa2, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75,
	0xac, 0x00, 0x70, 0x75, 0xac, 0x00, 0x7a, 0x7f, 0x93, 0xa2,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x7c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x00, 0x00, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x3c, 0x3c, 0x7c,
	0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x10, 0x01,
	0x00, 0x00, 0x22, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x13, 0x19, 0x17, 0x19, 0x19, 0x19, 0x46, 0x0f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x0e, 0x0e, 0x03, 0x00, 0x2d, 0xe2, 0x00, 0x02, 0x0e,
	0x1c, 0xe0, 0xe0, 0xf0, 0x0c, 0xe0, 0xe0, 0xf0, 0x6c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
	0x69, 0x10, 0x14, 0x10, 0x19, 0x19, 0x19, 0x1d, 0x20, 0x24,
	0x10, 0x10, 0x10, 0x4c, 0x54, 0x68, 0x78, 0x8c, 0xa0, 0xb4,
	0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x54, 0x68, 0x78, 0x8c,
	0xa0, 0xb9, 0xcd, 0x4c, 0x54, 0x68, 0x78, 0x8c, 0xa0, 0xb9,
	0xcd, 0x4c, 0x54, 0x68, 0x78, 0x8c, 0xa0, 0xb9, 0xcd, 0x20,
	0x20, 0x1c, 0x1a, 0x20, 0x20, 0x1c, 0x1a, 0x20, 0x20, 0x1c,
	0x1a, 0x20, 0x20, 0x1a, 0x18, 0x20, 0x20, 0x1a, 0x18, 0x20,
	0x20, 0x18, 0x16, 0x1e, 0x1e, 0x18, 0x16, 0x1e, 0x1e, 0x18,
	0x16, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x1a, 0x20, 0x1c, 0x1a,
	0x18, 0x18, 0x18, 0x16, 0x16, 0x20, 0x20, 0x20, 0x20, 0x1c,
	0x1a, 0x20, 0x1c, 0x1a, 0x18, 0x18, 0x18, 0x16, 0x16, 0x20,
	0x20, 0x20, 0x20, 0x1c, 0x1a, 0x20, 0x1c, 0x1a, 0x18, 0x18,
	0x18, 0x16, 0x16, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x1a, 0x20,
	0x1a, 0x18, 0x16, 0x16, 0x16, 0x14, 0x14, 0x20, 0x20, 0x20,
	0x20, 0x1c, 0x1a, 0x20, 0x1a, 0x18, 0x16, 0x14, 0x12, 0x10,
	0x10, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x1a, 0x20, 0x18, 0x14,
	0x10, 0x12, 0x10, 0x0e, 0x0e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1c,
	0x1a, 0x1e, 0x18, 0x14, 0x10, 0x12, 0x10, 0x0e, 0x0e, 0x1e,
	0x1e, 0x1e, 0x1e, 0x1c, 0x1a, 0x1e, 0x18, 0x14, 0x10, 0x12,
	0x10, 0x0e, 0x0e, 0x20, 0x20, 0x20, 0x1e, 0x1c, 0x1a, 0x1e,
	0x1c, 0x1a, 0x18, 0x18, 0x18, 0x16, 0x16, 0x20, 0x20, 0x20,
	0x1e, 0x1c, 0x1a, 0x1e, 0x1c, 0x1a, 0x18, 0x18, 0x18, 0x16,
	0x16, 0x20, 0x20, 0x20, 0x1e, 0x1c, 0x1a, 0x1e, 0x1c, 0x1a,
	0x18, 0x18, 0x18, 0x16, 0x16, 0x20, 0x20, 0x20, 0x1e, 0x1c,
	0x1a, 0x1e, 0x1a, 0x18, 0x16, 0x16, 0x16, 0x14, 0x14, 0x20,
	0x20, 0x20, 0x1e, 0x1c, 0x1a, 0x1e, 0x1a, 0x18, 0x16, 0x14,
	0x12, 0x10, 0x10, 0x20, 0x20, 0x20, 0x1e, 0x1c, 0x1a, 0x1e,
	0x16, 0x14, 0x10, 0x12, 0x10, 0x0e, 0x0e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1c, 0x1a, 0x1e, 0x16, 0x14, 0x10, 0x12, 0x10, 0x0e,
	0x0e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1c, 0x1a, 0x1e, 0x16, 0x14,
	0x10, 0x12, 0x10, 0x0e, 0x0e, 0x10, 0x16, 0x18, 0x40, 0x46,
	0x48, 0x30, 0x36, 0x38, 0x4c, 0x5c, 0x60, 0x8c, 0xa0, 0xb4,
	0xbd, 0xcd, 0x4c, 0x5c, 0x60, 0x8c, 0x90, 0xb4, 0xbd, 0xcd,
	0x4e, 0x56, 0x5e, 0x66, 0x8e, 0x96, 0xae, 0xbf, 0x4c, 0x50,
	0x5c, 0x68, 0x8c, 0xb4, 0xff, 0xff, 0x4c, 0x5c, 0x8c, 0xb4,
	0xff, 0xff, 0xff, 0xff, 0x4e, 0x5e, 0x66, 0x8e, 0x9e, 0xae,
	0xff, 0xff, 0x4c, 0x50, 0x54, 0x5c, 0x8c, 0xa0, 0xb4, 0xbd,
	0x4c, 0x5c, 0x68, 0x8c, 0x98, 0xb4, 0xbd, 0xcd, 0x4e, 0x56,
	0x5e, 0x8e, 0x96, 0xae, 0xbf, 0xc7, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c,
	0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c
};

static const uint8_t ar9380_def_rom_x113[] = {
	0x02, 0x06, 0x00, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x78, 0x31,
	0x31, 0x33, 0x2d, 0x30, 0x32, 0x33, 0x2d, 0x66, 0x30, 0x30,
	0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0x00, 0x77, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x0d, 0x00, 0x06, 0x00, 0x08, 0xff, 0x21, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x44, 0x44, 0x04,
	0x00, 0x50, 0x01, 0x50, 0x01, 0x50, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x19, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x03, 0x00,
	0x2c, 0xe2, 0x00, 0x02, 0x0e, 0x1c, 0x80, 0xc0, 0x80, 0x0c,
	0x80, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x89,
	0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xac, 0x70, 0x89, 0xac,
	0x70, 0x89, 0xac, 0x70, 0x89, 0xac, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x22, 0x22,
	0x20, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x1c, 0x20, 0x20, 0x1e, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x20, 0x20, 0x1e, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1c,
	0x20, 0x20, 0x1e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e,
	0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e, 0x1c, 0x1a, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e,
	0x1c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1c, 0x1e, 0x1e, 0x1c, 0x1a, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x15, 0x17, 0x41, 0x42, 0x45, 0x47, 0x31, 0x32,
	0x35, 0x37, 0x70, 0x75, 0x9d, 0xa2, 0x70, 0x75, 0xa2, 0xff,
	0x70, 0x75, 0xa2, 0xff, 0x7a, 0x7f, 0x93, 0x98, 0x70, 0x75,
	0xac, 0xb8, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75, 0xac, 0x00,
	0x7a, 0x7f, 0x93, 0xa2, 0x70, 0x75, 0xac, 0x00, 0x70, 0x75,
	0xac, 0x00, 0x70, 0x75, 0xac, 0x00, 0x7a, 0x7f, 0x93, 0xa2,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x7c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x00, 0x00, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x3c, 0x3c, 0x7c,
	0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0x3c,
	0x3c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x20, 0x02,
	0x00, 0x00, 0x11, 0x11, 0x01, 0x00, 0x50, 0x01, 0x50, 0x01,
	0x50, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
	0x8c, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x0e, 0x0e, 0x03, 0x00, 0x2d, 0xe2, 0x00, 0x02, 0x0e,
	0x1c, 0xe0, 0xe0, 0xf0, 0x0c, 0xe0, 0xe0, 0xf0, 0x6c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
	0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4c, 0x58, 0x68, 0x78, 0x8c, 0xa0, 0xbd,
	0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x54, 0x68, 0x78, 0x8c,
	0xa0, 0xbd, 0xc5, 0x4c, 0x58, 0x68, 0x78, 0x8c, 0xb4, 0xbd,
	0xcd, 0x4e, 0x56, 0x68, 0x7a, 0x8e, 0xae, 0xbf, 0xcd, 0x2a,
	0x28, 0x28, 0x22, 0x2a, 0x28, 0x28, 0x22, 0x2a, 0x28, 0x28,
	0x22, 0x2a, 0x28, 0x28, 0x22, 0x2a, 0x28, 0x28, 0x22, 0x2a,
	0x28, 0x28, 0x22, 0x2a, 0x28, 0x28, 0x22, 0x2a, 0x28, 0x28,
	0x22, 0x28, 0x28, 0x28, 0x28, 0x20, 0x1c, 0x28, 0x28, 0x20,
	0x1c, 0x28, 0x28, 0x20, 0x14, 0x28, 0x28, 0x28, 0x28, 0x20,
	0x1c, 0x28, 0x28, 0x20, 0x1c, 0x28, 0x28, 0x20, 0x14, 0x28,
	0x28, 0x28, 0x28, 0x20, 0x1c, 0x28, 0x28, 0x20, 0x1c, 0x28,
	0x28, 0x20, 0x14, 0x28, 0x28, 0x28, 0x28, 0x20, 0x1c, 0x28,
	0x28, 0x20, 0x1c, 0x28, 0x28, 0x20, 0x14, 0x28, 0x28, 0x28,
	0x28, 0x20, 0x1c, 0x28, 0x28, 0x20, 0x1c, 0x28, 0x28, 0x20,
	0x14, 0x28, 0x28, 0x28, 0x28, 0x20, 0x1c, 0x28, 0x28, 0x20,
	0x1c, 0x28, 0x28, 0x20, 0x14, 0x26, 0x26, 0x26, 0x26, 0x20,
	0x1c, 0x26, 0x26, 0x20, 0x1c, 0x26, 0x26, 0x20, 0x1a, 0x24,
	0x24, 0x24, 0x24, 0x20, 0x1c, 0x24, 0x24, 0x20, 0x1c, 0x24,
	0x24, 0x20, 0x1a, 0x28, 0x28, 0x28, 0x26, 0x1e, 0x1a, 0x28,
	0x28, 0x1e, 0x1a, 0x28, 0x28, 0x1e, 0x18, 0x28, 0x28, 0x28,
	0x26, 0x1e, 0x1a, 0x28, 0x28, 0x1e, 0x1a, 0x28, 0x28, 0x1e,
	0x18, 0x28, 0x28, 0x28, 0x26, 0x1e, 0x1a, 0x28, 0x28, 0x1e,
	0x1a, 0x28, 0x28, 0x1e, 0x18, 0x28, 0x28, 0x28, 0x26, 0x1e,
	0x1a, 0x28, 0x28, 0x1e, 0x1a, 0x28, 0x28, 0x1e, 0x18, 0x28,
	0x28, 0x28, 0x26, 0x1e, 0x1a, 0x28, 0x28, 0x1e, 0x1a, 0x28,
	0x28, 0x1e, 0x18, 0x28, 0x28, 0x28, 0x26, 0x1e, 0x1a, 0x28,
	0x28, 0x1e, 0x1a, 0x28, 0x28, 0x1e, 0x18, 0x24, 0x24, 0x24,
	0x24, 0x1e, 0x1a, 0x24, 0x24, 0x1e, 0x1a, 0x24, 0x24, 0x1e,
	0x18, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x1a, 0x22, 0x22, 0x1e,
	0x1a, 0x22, 0x22, 0x1e, 0x18, 0x10, 0x16, 0x18, 0x40, 0x46,
	0x48, 0x30, 0x36, 0x38, 0x4c, 0x5c, 0x60, 0x8c, 0xa0, 0xb4,
	0xbd, 0xcd, 0x4c, 0x5c, 0x60, 0x8c, 0x90, 0xb4, 0xbd, 0xcd,
	0x4e, 0x56, 0x5e, 0x66, 0x8e, 0x96, 0xae, 0xbf, 0x4c, 0x50,
	0x5c, 0x68, 0x8c, 0xb4, 0xff, 0xff, 0x4c, 0x5c, 0x8c, 0xb4,
	0xff, 0xff, 0xff, 0xff, 0x4e, 0x5e, 0x66, 0x8e, 0x9e, 0xae,
	0xff, 0xff, 0x4c, 0x50, 0x54, 0x5c, 0x8c, 0xa0, 0xb4, 0xbd,
	0x4c, 0x5c, 0x68, 0x8c, 0x98, 0xb4, 0xbd, 0xcd, 0x4e, 0x56,
	0x5e, 0x8e, 0x96, 0xae, 0xbf, 0xc7, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x3c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x3c, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c,
	0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c
};

static const uint8_t *ar9380_rom_templates[] = {
	ar9380_def_rom,
	ar9380_def_rom_h112,
	ar9380_def_rom_h116,
	ar9380_def_rom_x112,
	ar9380_def_rom_x113
};

/* Macro to "pack" registers to 16-bit to save some .rodata space. */
#define P(x)	((x) >> 2)

/*
 * AR9380 2.2 programming.
 */
static const uint16_t ar9380_2_2_regs[] = {
	P(0x07010), P(0x01030), P(0x01070), P(0x010b0), P(0x08014),
	P(0x0801c), P(0x08120), P(0x081d0), P(0x08318), P(0x1609c),
	P(0x160ac), P(0x160b0), P(0x1610c), P(0x16140), P(0x1650c),
	P(0x16540), P(0x1690c), P(0x16940), P(0x09810), P(0x09820),
	P(0x09824), P(0x09828), P(0x0982c), P(0x09830), P(0x09c00),
	P(0x09e00), P(0x09e04), P(0x09e0c), P(0x09e10), P(0x09e14),
	P(0x09e18), P(0x09e1c), P(0x09e20), P(0x09e2c), P(0x09e3c),
	P(0x09e44), P(0x09e48), P(0x09fc8), P(0x0a204), P(0x0a208),
	P(0x0a22c), P(0x0a230), P(0x0a234), P(0x0a238), P(0x0a250),
	P(0x0a254), P(0x0a258), P(0x0a25c), P(0x0a260), P(0x0a264),
	P(0x0a280), P(0x0a284), P(0x0a288), P(0x0a28c), P(0x0a2c4),
	P(0x0a2d0), P(0x0a2d8), P(0x0a358), P(0x0a830), P(0x0ae04),
	P(0x0ae18), P(0x0ae1c), P(0x0ae20), P(0x0b284), P(0x0b830),
	P(0x0be04), P(0x0be18), P(0x0be1c), P(0x0be20), P(0x0c284)
};

static const uint32_t ar9380_2_2_vals_5g20[] = {
	0x00000023, 0x00000230, 0x00000168, 0x00000e60, 0x03e803e8,
	0x128d8027, 0x08f04800, 0x00003210, 0x00003e80, 0x0dd08f29,
	0xa4653c00, 0x03284f3e, 0x08000000, 0x10804008, 0x08000000,
	0x10804008, 0x08000000, 0x10804008, 0xd00a8005, 0x206a022e,
	0x5ac640d0, 0x06903081, 0x05eea6d4, 0x0000059c, 0x000000c4,
	0x0372111a, 0x001c2020, 0x6c4000e2, 0x7ec88d2e, 0x37b95d5e,
	0x00000000, 0x0001cf9c, 0x000003b5, 0x0000001c, 0xcf946220,
	0x02321e27, 0x5030201a, 0x0003f000, 0x000037c0, 0x00000104,
	0x01026a2f, 0x0000000a, 0x00000fff, 0xffb81018, 0x00000000,
	0x000007d0, 0x02020002, 0x01000e0e, 0x0a021501, 0x00000e0e,
	0x00000007, 0x00000000, 0x00000110, 0x00022222, 0x00158d18,
	0x00071981, 0x7999a83a, 0x00000000, 0x0000019c, 0x001c0000,
	0x00000000, 0x0000019c, 0x000001b5, 0x00000000, 0x0000019c,
	0x001c0000, 0x00000000, 0x0000019c, 0x000001b5, 0x00000000
};

#ifndef IEEE80211_NO_HT
static const uint32_t ar9380_2_2_vals_5g40[] = {
	0x00000023, 0x00000460, 0x000002d0, 0x00001cc0, 0x07d007d0,
	0x128d804f, 0x08f04800, 0x00003210, 0x00007d00, 0x0dd08f29,
	0xa4653c00, 0x03284f3e, 0x00000000, 0x10804008, 0x00000000,
	0x10804008, 0x00000000, 0x10804008, 0xd00a8005, 0x206a022e,
	0x5ac640d0, 0x06903081, 0x05eea6d4, 0x0000059c, 0x000000c4,
	0x0372111a, 0x001c2020, 0x6d4000e2, 0x7ec88d2e, 0x37b9605e,
	0x00000000, 0x0001cf9c, 0x000003b5, 0x0000001c, 0xcf946220,
	0x02321e27, 0x5030201a, 0x0003f000, 0x000037c4, 0x00000104,
	0x01026a2f, 0x00000014, 0x10000fff, 0xffb81018, 0x00000000,
	0x00000fa0, 0x02020002, 0x01000e0e, 0x0a021501, 0x00000e0e,
	0x00000007, 0x00000000, 0x00000110, 0x00022222, 0x00158d18,
	0x00071981, 0x7999a83a, 0x00000000, 0x0000019c, 0x001c0000,
	0x00000000, 0x0000019c, 0x000001b5, 0x00000000, 0x0000019c,
	0x001c0000, 0x00000000, 0x0000019c, 0x000001b5, 0x00000000
};

static const uint32_t ar9380_2_2_vals_2g40[] = {
	0x00000023, 0x000002c0, 0x00000318, 0x00007c70, 0x10801600,
	0x12e00057, 0x08f04810, 0x0000320a, 0x00006880, 0x0b283f31,
	0x24652800, 0x05d08f20, 0x00000000, 0x50804008, 0x00000000,
	0x50804008, 0x00000000, 0x50804008, 0xd00a8011, 0x206a012e,
	0x5ac640d0, 0x06903881, 0x05eea6d4, 0x0000119c, 0x000000c4,
	0x037216a0, 0x001c2020, 0x6d4000e2, 0x7ec84d2e, 0x3379605e,
	0x00000000, 0x00021f9c, 0x000003ce, 0x00000021, 0xcf946222,
	0x02291e27, 0x50302012, 0x0001a000, 0x000037c4, 0x00000004,
	0x01026a2f, 0x00000016, 0x10000fff, 0xffb81018, 0x00000210,
	0x00001130, 0x02020002, 0x01000e0e, 0x3a021501, 0x00000e0e,
	0x0000000b, 0x00000150, 0x00000110, 0x00022222, 0x00158d18,
	0x00071981, 0x7999a83a, 0x00000000, 0x0000019c, 0x001c0000,
	0x00000000, 0x0000019c, 0x000001ce, 0x00000150, 0x0000019c,
	0x001c0000, 0x00000000, 0x0000019c, 0x000001ce, 0x00000150
};
#endif

static const uint32_t ar9380_2_2_vals_2g20[] = {
	0x00000023, 0x00000160, 0x0000018c, 0x00003e38, 0x08400b00,
	0x12e0002b, 0x08f04810, 0x0000320a, 0x00003440, 0x0b283f31,
	0x24652800, 0x05d08f20, 0x00000000, 0x50804008, 0x00000000,
	0x50804008, 0x00000000, 0x50804008, 0xd00a8011, 0x206a012e,
	0x5ac640d0, 0x06903881, 0x05eea6d4, 0x0000119c, 0x000000c4,
	0x037216a0, 0x001c2020, 0x6c4000e2, 0x7ec84d2e, 0x33795d5e,
	0x00000000, 0x00021f9c, 0x000003ce, 0x00000021, 0xcf946222,
	0x02291e27, 0x50302012, 0x0001a000, 0x000037c0, 0x00000004,
	0x01026a2f, 0x0000000b, 0x00000fff, 0xffb81018, 0x00000108,
	0x00000898, 0x02020002, 0x01000e0e, 0x3a021501, 0x00000e0e,
	0x0000000b, 0x00000150, 0x00000110, 0x00022222, 0x00158d18,
	0x00071982, 0x7999a83a, 0x00000000, 0x0000019c, 0x001c0000,
	0x00000000, 0x0000019c, 0x000001ce, 0x00000150, 0x0000019c,
	0x001c0000, 0x00000000, 0x0000019c, 0x000001ce, 0x00000150
};

static const uint16_t ar9380_2_2_cm_regs[] = {
	P(0x040a4), P(0x07008), P(0x07020), P(0x07034), P(0x07038),
	P(0x07048), P(0x00008), P(0x00030), P(0x00034), P(0x00040),
	P(0x00044), P(0x00048), P(0x0004c), P(0x00050), P(0x01040),
	P(0x01044), P(0x01048), P(0x0104c), P(0x01050), P(0x01054),
	P(0x01058), P(0x0105c), P(0x01060), P(0x01064), P(0x010f0),
	P(0x01270), P(0x012b0), P(0x012f0), P(0x0143c), P(0x0147c),
	P(0x08000), P(0x08004), P(0x08008), P(0x0800c), P(0x08018),
	P(0x08020), P(0x08038), P(0x0803c), P(0x08040), P(0x08044),
	P(0x08048), P(0x0804c), P(0x08054), P(0x08058), P(0x0805c),
	P(0x08060), P(0x08064), P(0x08070), P(0x08074), P(0x08078),
	P(0x0809c), P(0x080a0), P(0x080a4), P(0x080a8), P(0x080ac),
	P(0x080b0), P(0x080b4), P(0x080b8), P(0x080bc), P(0x080c0),
	P(0x080c4), P(0x080c8), P(0x080cc), P(0x080d0), P(0x080d4),
	P(0x080d8), P(0x080dc), P(0x080e0), P(0x080e4), P(0x080e8),
	P(0x080ec), P(0x080f0), P(0x080f4), P(0x080fc), P(0x08100),
	P(0x08108), P(0x0810c), P(0x08110), P(0x08114), P(0x08118),
	P(0x0811c), P(0x08124), P(0x08128), P(0x0812c), P(0x08130),
	P(0x08134), P(0x08138), P(0x0813c), P(0x08144), P(0x08168),
	P(0x0816c), P(0x081c0), P(0x081c4), P(0x081c8), P(0x081cc),
	P(0x081ec), P(0x081f0), P(0x081f4), P(0x081f8), P(0x081fc),
	P(0x08240), P(0x08244), P(0x08248), P(0x0824c), P(0x08250),
	P(0x08254), P(0x08258), P(0x0825c), P(0x08260), P(0x08264),
	P(0x08268), P(0x0826c), P(0x08270), P(0x08274), P(0x08278),
	P(0x0827c), P(0x08284), P(0x08288), P(0x0828c), P(0x08294),
	P(0x08298), P(0x0829c), P(0x08300), P(0x08314), P(0x0831c),
	P(0x08328), P(0x0832c), P(0x08330), P(0x08334), P(0x08338),
	P(0x0833c), P(0x08340), P(0x08344), P(0x08348), P(0x0835c),
	P(0x08360), P(0x08364), P(0x08368), P(0x08370), P(0x08374),
	P(0x08378), P(0x0837c), P(0x08380), P(0x08384), P(0x08390),
	P(0x08394), P(0x08398), P(0x0839c), P(0x083a0), P(0x083a4),
	P(0x083a8), P(0x083ac), P(0x083b0), P(0x083b4), P(0x083b8),
	P(0x083bc), P(0x083c0), P(0x083c4), P(0x083c8), P(0x083cc),
	P(0x083d0), P(0x09800), P(0x09804), P(0x09808), P(0x0980c),
	P(0x09814), P(0x09818), P(0x0981c), P(0x09834), P(0x09838),
	P(0x0983c), P(0x09880), P(0x09884), P(0x098a4), P(0x098b0),
	P(0x098d0), P(0x098d4), P(0x098dc), P(0x098f0), P(0x098f4),
	P(0x09c04), P(0x09c08), P(0x09c0c), P(0x09c10), P(0x09c14),
	P(0x09c18), P(0x09c1c), P(0x09d00), P(0x09d04), P(0x09d08),
	P(0x09d0c), P(0x09d10), P(0x09d14), P(0x09d18), P(0x09e08),
	P(0x09e24), P(0x09e28), P(0x09e30), P(0x09e34), P(0x09e38),
	P(0x09e40), P(0x09e4c), P(0x09e50), P(0x09e54), P(0x09fc0),
	P(0x09fc4), P(0x09fcc), P(0x09fd0), P(0x0a20c), P(0x0a220),
	P(0x0a224), P(0x0a228), P(0x0a23c), P(0x0a244), P(0x0a2a0),
	P(0x0a2c0), P(0x0a2c8), P(0x0a2cc), P(0x0a2d4), P(0x0a2ec),
	P(0x0a2f0), P(0x0a2f4), P(0x0a2f8), P(0x0a344), P(0x0a34c),
	P(0x0a350), P(0x0a364), P(0x0a370), P(0x0a390), P(0x0a394),
	P(0x0a398), P(0x0a39c), P(0x0a3a0), P(0x0a3a4), P(0x0a3a8),
	P(0x0a3ac), P(0x0a3c0), P(0x0a3c4), P(0x0a3c8), P(0x0a3cc),
	P(0x0a3d0), P(0x0a3d4), P(0x0a3d8), P(0x0a3dc), P(0x0a3e0),
	P(0x0a3e4), P(0x0a3e8), P(0x0a3ec), P(0x0a3f0), P(0x0a3f4),
	P(0x0a3f8), P(0x0a3fc), P(0x0a400), P(0x0a404), P(0x0a408),
	P(0x0a40c), P(0x0a414), P(0x0a418), P(0x0a41c), P(0x0a420),
	P(0x0a424), P(0x0a428), P(0x0a42c), P(0x0a430), P(0x0a434),
	P(0x0a438), P(0x0a43c), P(0x0a440), P(0x0a444), P(0x0a448),
	P(0x0a44c), P(0x0a450), P(0x0a458), P(0x0a640), P(0x0a644),
	P(0x0a648), P(0x0a64c), P(0x0a670), P(0x0a674), P(0x0a678),
	P(0x0a67c), P(0x0a680), P(0x0a684), P(0x0a688), P(0x0a690),
	P(0x0a7c0), P(0x0a7c4), P(0x0a7c8), P(0x0a7cc), P(0x0a7d0),
	P(0x0a7d4), P(0x0a7dc), P(0x0a8d0), P(0x0a8d4), P(0x0a8dc),
	P(0x0a8f0), P(0x0a8f4), P(0x0b2d0), P(0x0b2d4), P(0x0b2ec),
	P(0x0b2f0), P(0x0b2f4), P(0x0b2f8), P(0x0b408), P(0x0b40c),
	P(0x0b420), P(0x0b8d0), P(0x0b8d4), P(0x0b8dc), P(0x0b8f0),
	P(0x0b8f4), P(0x0c2d0), P(0x0c2d4), P(0x0c2ec), P(0x0c2f0),
	P(0x0c2f4), P(0x0c2f8), P(0x0c408), P(0x0c40c), P(0x0c420),
	P(0x16000), P(0x16004), P(0x16008), P(0x1600c), P(0x16040),
	P(0x1604c), P(0x16050), P(0x16054), P(0x16058), P(0x1605c),
	P(0x16060), P(0x16064), P(0x1606c), P(0x16080), P(0x16084),
	P(0x16088), P(0x1608c), P(0x16090), P(0x16098), P(0x160a0),
	P(0x160a4), P(0x160a8), P(0x160b4), P(0x160c0), P(0x160c4),
	P(0x160c8), P(0x160cc), P(0x16100), P(0x16104), P(0x16108),
	P(0x16144), P(0x16148), P(0x16280), P(0x16284), P(0x16288),
	P(0x1628c), P(0x16290), P(0x16294), P(0x16380), P(0x16384),
	P(0x16388), P(0x1638c), P(0x16390), P(0x16394), P(0x16398),
	P(0x1639c), P(0x163a0), P(0x163a4), P(0x163a8), P(0x163ac),
	P(0x163b0), P(0x163b4), P(0x163b8), P(0x163bc), P(0x163c0),
	P(0x163c4), P(0x163c8), P(0x163cc), P(0x163d0), P(0x163d4),
	P(0x16400), P(0x16404), P(0x16408), P(0x1640c), P(0x16440),
	P(0x1644c), P(0x16450), P(0x16454), P(0x16458), P(0x1645c),
	P(0x16460), P(0x16464), P(0x1646c), P(0x16500), P(0x16504),
	P(0x16508), P(0x16544), P(0x16548), P(0x16780), P(0x16784),
	P(0x16788), P(0x1678c), P(0x16790), P(0x16794), P(0x16798),
	P(0x1679c), P(0x167a0), P(0x167a4), P(0x167a8), P(0x167ac),
	P(0x167b0), P(0x167b4), P(0x167b8), P(0x167bc), P(0x167c0),
	P(0x167c4), P(0x167c8), P(0x167cc), P(0x167d0), P(0x167d4),
	P(0x16800), P(0x16804), P(0x16808), P(0x1680c), P(0x16840),
	P(0x1684c), P(0x16850), P(0x16854), P(0x16858), P(0x1685c),
	P(0x16860), P(0x16864), P(0x1686c), P(0x16900), P(0x16904),
	P(0x16908), P(0x16944), P(0x16948), P(0x16b80), P(0x16b84),
	P(0x16b88), P(0x16b8c), P(0x16b90), P(0x16b94), P(0x16b98),
	P(0x16b9c), P(0x16ba0), P(0x16ba4), P(0x16ba8), P(0x16bac),
	P(0x16bb0), P(0x16bb4), P(0x16bb8), P(0x16bbc), P(0x16bc0),
	P(0x16bc4), P(0x16bc8), P(0x16bcc), P(0x16bd0), P(0x16bd4)
};

static const uint32_t ar9380_2_2_cm_vals[] = {
	0x00a0c1c9, 0x00000000, 0x00000000, 0x00000002, 0x000004c2,
	0x00000008, 0x00000000, 0x00020085, 0x00000005, 0x00000000,
	0x00000000, 0x00000008, 0x00000010, 0x00000000, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x00000100,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x000fc78f,
	0x0000000f, 0x00000000, 0x00000310, 0x00000020, 0x00000000,
	0x0000000f, 0x00000000, 0x02ff0000, 0x0e070605, 0x0000000d,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2a800000,
	0x06900168, 0x13881c20, 0x01f40000, 0x00252500, 0x00a00000,
	0x00400000, 0x00000000, 0xffffffff, 0x0000ffff, 0x3f3f3f3f,
	0x00000000, 0x00000000, 0x00000000, 0x00020000, 0x00000000,
	0x00000052, 0x00000000, 0x00000000, 0x000007ff, 0x000000aa,
	0x00003210, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x0000ffff, 0xffffffff, 0x00000000,
	0x00000000, 0x00000000, 0x33332210, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00100000, 0x0010f424, 0x00000800, 0x0001e848, 0x00000000,
	0x00000000, 0x00000000, 0x40000000, 0x00080922, 0x9bc00010,
	0xffffffff, 0x0000ffff, 0x00000000, 0x40000000, 0x003e4180,
	0x00000004, 0x0000002c, 0x0000002c, 0x000000ff, 0x00000000,
	0x00000000, 0x00000000, 0x00000140, 0x00000000, 0x0000010d,
	0x00000000, 0x00000007, 0x00000302, 0x00000700, 0x00ff0000,
	0x02400000, 0x000107ff, 0xaa48105b, 0x008f0000, 0x00000000,
	0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x000000ff,
	0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff,
	0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x0000fa14,
	0x000f0c00, 0x33332210, 0x33332210, 0x33332210, 0x33332210,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000200,
	0x000301ff, 0xafe68e30, 0xfd14e000, 0x9c0a9f6b, 0x04900000,
	0x9280c00a, 0x00000000, 0x00020028, 0x6400a290, 0x0108ecff,
	0x0d000600, 0x201fff00, 0x00001042, 0x00200400, 0x32840bbe,
	0x004b6a8e, 0x00000820, 0x00000000, 0x00000000, 0x00000000,
	0xff55ff55, 0x0320ff55, 0x00000000, 0x00000000, 0x00046384,
	0x05b6b440, 0x00b6b440, 0xc080a333, 0x40206c10, 0x009c4060,
	0x9883800a, 0x01834061, 0x00c0040b, 0x00000000, 0x0038230c,
	0x990bb515, 0x0c6f0000, 0x06336f77, 0x6af6532f, 0x0cc80c00,
	0x0d261820, 0x00001004, 0x00ff03f1, 0x00000000, 0x803e4788,
	0x0001efb5, 0x40000014, 0x01193b93, 0x00000000, 0x00000000,
	0x00000000, 0x10002310, 0x00000000, 0x0c000000, 0x00000001,
	0x00000001, 0x00000000, 0x18c43433, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0000a000, 0x00000000, 0x00000000, 0x00000001, 0x00000444,
	0x001f0e0f, 0x0075393f, 0xb79f6427, 0x00000000, 0xaaaaaaaa,
	0x3c466478, 0x20202020, 0x22222220, 0x20200020, 0x20202020,
	0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
	0x20202020, 0x20202020, 0x20202020, 0x00000000, 0x00000246,
	0x0cdbd380, 0x000f0f01, 0x8fa91f01, 0x00000000, 0x0e79e5c6,
	0x00820820, 0x1ce739ce, 0x2d001dce, 0x1ce739ce, 0x000001ce,
	0x1ce739ce, 0x000001ce, 0x1ce739ce, 0x1ce739ce, 0x00000000,
	0x00001801, 0x00100000, 0x00000000, 0x00000000, 0x06000080,
	0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x3fad9d74,
	0x0048060a, 0x00003c37, 0x03020100, 0x09080504, 0x0d0c0b0a,
	0x13121110, 0x31301514, 0x35343332, 0x00000036, 0x00000838,
	0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x00000000,
	0x00000004, 0x00000001, 0x004b6a8e, 0x00000820, 0x00000000,
	0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x0e79e5c0, 0x00820820,
	0x00000000, 0x004b6a8e, 0x00000820, 0x00000000, 0x00000000,
	0x00000000, 0x00000080, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x0e79e5c0, 0x00820820, 0x00000000,
	0x36db6db6, 0x6db6db40, 0x73f00000, 0x00000000, 0x7f80fff8,
	0x76d005b5, 0x556cf031, 0x13449440, 0x0c51c92c, 0x3db7fffc,
	0xfffffffc, 0x000f0278, 0x6db60000, 0x00000000, 0x0e48048c,
	0x54214514, 0x119f481e, 0x24926490, 0xd2888888, 0x0a108ffe,
	0x812fc370, 0x423c8000, 0x92480080, 0x00adb6d0, 0x6db6db60,
	0x6db6db6c, 0x01e6c000, 0x3fffbe01, 0xfff80000, 0x00080010,
	0x02084080, 0x00000000, 0x058a0001, 0x3d840208, 0x05a20408,
	0x00038c07, 0x00000004, 0x458aa14f, 0x00000000, 0x00000000,
	0x00800700, 0x00800700, 0x00800700, 0x00000000, 0x00000000,
	0x00000000, 0x00000001, 0x00000001, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000a0,
	0x000c0000, 0x14021402, 0x00001402, 0x00000000, 0x00000000,
	0x36db6db6, 0x6db6db40, 0x73f00000, 0x00000000, 0x7f80fff8,
	0x76d005b5, 0x556cf031, 0x13449440, 0x0c51c92c, 0x3db7fffc,
	0xfffffffc, 0x000f0278, 0x6db60000, 0x3fffbe01, 0xfff80000,
	0x00080010, 0x02084080, 0x00000000, 0x00000000, 0x00000000,
	0x00800700, 0x00800700, 0x00800700, 0x00000000, 0x00000000,
	0x00000000, 0x00000001, 0x00000001, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000a0,
	0x000c0000, 0x14021402, 0x00001402, 0x00000000, 0x00000000,
	0x36db6db6, 0x6db6db40, 0x73f00000, 0x00000000, 0x7f80fff8,
	0x76d005b5, 0x556cf031, 0x13449440, 0x0c51c92c, 0x3db7fffc,
	0xfffffffc, 0x000f0278, 0x6db60000, 0x3fffbe01, 0xfff80000,
	0x00080010, 0x02084080, 0x00000000, 0x00000000, 0x00000000,
	0x00800700, 0x00800700, 0x00800700, 0x00000000, 0x00000000,
	0x00000000, 0x00000001, 0x00000001, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000a0,
	0x000c0000, 0x14021402, 0x00001402, 0x00000000, 0x00000000
};

static const uint16_t ar9380_2_2_fast_clock_regs[] = {
	P(0x01030), P(0x01070), P(0x010b0), P(0x08014), P(0x0801c),
	P(0x08318), P(0x09e00), P(0x0a230), P(0x0a254)
};

static const uint32_t ar9380_2_2_fast_clock_vals_5g20[] = {
	0x00000268, 0x0000018c, 0x00000fd0, 0x044c044c, 0x148ec02b,
	0x000044c0, 0x0372131c, 0x0000000b, 0x00000898
};

#ifndef IEEE80211_NO_HT
static const uint32_t ar9380_2_2_fast_clock_vals_5g40[] = {
	0x000004d0, 0x00000318, 0x00001fa0, 0x08980898, 0x148ec057,
	0x00008980, 0x0372131c, 0x00000016, 0x00001130
};
#endif

static const struct athn_ini ar9380_2_2_ini = {
	nitems(ar9380_2_2_regs),
	ar9380_2_2_regs,
	ar9380_2_2_vals_5g20,
#ifndef IEEE80211_NO_HT
	ar9380_2_2_vals_5g40,
	ar9380_2_2_vals_2g40,
#endif
	ar9380_2_2_vals_2g20,
	nitems(ar9380_2_2_cm_regs),
	ar9380_2_2_cm_regs,
	ar9380_2_2_cm_vals,
	nitems(ar9380_2_2_fast_clock_regs),
	ar9380_2_2_fast_clock_regs,
	ar9380_2_2_fast_clock_vals_5g20,
#ifndef IEEE80211_NO_HT
	ar9380_2_2_fast_clock_vals_5g40
#endif
};

/*
 * AR9485 1.0 programming.
 */
static const uint16_t ar9485_1_0_regs[] = {
	P(0x01030), P(0x01070), P(0x010b0), P(0x08014), P(0x0801c),
	P(0x08120), P(0x081d0), P(0x08318), P(0x1609c), P(0x160ac),
	P(0x160b0), P(0x1610c), P(0x16140), P(0x09810), P(0x09820),
	P(0x09824), P(0x09828), P(0x0982c), P(0x09830), P(0x09c00),
	P(0x09e00), P(0x09e04), P(0x09e0c), P(0x09e10), P(0x09e14),
	P(0x09e18), P(0x09e1c), P(0x09e20), P(0x09e2c), P(0x09e3c),
	P(0x09e44), P(0x09e48), P(0x09fc8), P(0x0a204), P(0x0a208),
	P(0x0a230), P(0x0a234), P(0x0a238), P(0x0a250), P(0x0a254),
	P(0x0a258), P(0x0a25c), P(0x0a260), P(0x0a264), P(0x0a280),
	P(0x0a284), P(0x0a288), P(0x0a28c), P(0x0a2c4), P(0x0a2d0),
	P(0x0a2d8), P(0x0a358), P(0x0be04), P(0x0be18)
};

static const uint32_t ar9485_1_0_vals_2g40[] = {
	0x000002c0, 0x00000318, 0x00007c70, 0x10801600, 0x12e00057,
	0x08f04810, 0x0000320a, 0x00006880, 0x24611800, 0x03284f3e,
	0x00170000, 0x10804008, 0x00000000, 0xd00a8005, 0x206a002e,
	0x5ac640d0, 0x06903881, 0x05eea6d4, 0x0000059c, 0x00000044,
	0x037216a0, 0x00182020, 0x6d4000e2, 0x7ec80d2e, 0x3139605e,
	0x00000000, 0x00021f9c, 0x000003ce, 0x00000021, 0xcf946222,
	0x02282324, 0x50302010, 0x0001a000, 0x01303fc4, 0x00000004,
	0x00004016, 0x10000fff, 0xffb81018, 0x00000210, 0x00001130,
	0x02020002, 0x01000e0e, 0x3a021501, 0x00000e0e, 0x0000000b,
	0x000002a0, 0x00000000, 0x00000000, 0x00158d18, 0x00071981,
	0xf999a83a, 0x00000000, 0x00802020, 0x00000000
};

static const uint32_t ar9485_1_0_vals_2g20[] = {
	0x00000160, 0x0000018c, 0x00003e38, 0x08400b00, 0x12e0002b,
	0x08f04810, 0x0000320a, 0x00003440, 0x000160b0, 0x0001610c,
	0x00016140, 0x00000000, 0x00000000, 0xd00a8005, 0x206a002e,
	0x5ac640d0, 0x06903881, 0x05eea6d4, 0x0000059c, 0x00000044,
	0x037216a0, 0x00182020, 0x6c4000e2, 0x7ec80d2e, 0x31395d5e,
	0x00000000, 0x00021f9c, 0x000003ce, 0x00000021, 0xcf946222,
	0x02282324, 0x50302010, 0x0001a000, 0x01303fc0, 0x00000004,
	0x0000400b, 0x10000fff, 0xffb81018, 0x00000108, 0x00000898,
	0x02020002, 0x01000e0e, 0x3a021501, 0x00000e0e, 0x0000000b,
	0x000002a0, 0x00000000, 0x00000000, 0x00158d18, 0x00071982,
	0xf999a83a, 0x00000000, 0x00802020, 0x00000000
};

static const uint16_t ar9485_1_0_cm_regs[] = {
	P(0x040a4), P(0x07048), P(0x00008), P(0x00030), P(0x00034),
	P(0x00040), P(0x00044), P(0x00048), P(0x0004c), P(0x00050),
	P(0x01040), P(0x01044), P(0x01048), P(0x0104c), P(0x01050),
	P(0x01054), P(0x01058), P(0x0105c), P(0x01060), P(0x01064),
	P(0x010f0), P(0x01270), P(0x012b0), P(0x012f0), P(0x0143c),
	P(0x0147c), P(0x08000), P(0x08004), P(0x08008), P(0x0800c),
	P(0x08018), P(0x08020), P(0x08038), P(0x0803c), P(0x08040),
	P(0x08044), P(0x08048), P(0x0804c), P(0x08054), P(0x08058),
	P(0x0805c), P(0x08060), P(0x08064), P(0x08070), P(0x08074),
	P(0x08078), P(0x0809c), P(0x080a0), P(0x080a4), P(0x080a8),
	P(0x080ac), P(0x080b0), P(0x080b4), P(0x080b8), P(0x080bc),
	P(0x080c0), P(0x080c4), P(0x080c8), P(0x080cc), P(0x080d0),
	P(0x080d4), P(0x080d8), P(0x080dc), P(0x080e0), P(0x080e4),
	P(0x080e8), P(0x080ec), P(0x080f0), P(0x080f4), P(0x080fc),
	P(0x08100), P(0x08108), P(0x0810c), P(0x08110), P(0x08114),
	P(0x08118), P(0x0811c), P(0x08124), P(0x08128), P(0x0812c),
	P(0x08130), P(0x08134), P(0x08138), P(0x0813c), P(0x08144),
	P(0x08168), P(0x0816c), P(0x08170), P(0x08174), P(0x08178),
	P(0x0817c), P(0x081c0), P(0x081c4), P(0x081c8), P(0x081cc),
	P(0x081d4), P(0x081ec), P(0x081f0), P(0x081f4), P(0x081f8),
	P(0x081fc), P(0x08240), P(0x08244), P(0x08248), P(0x0824c),
	P(0x08250), P(0x08254), P(0x08258), P(0x0825c), P(0x08260),
	P(0x08264), P(0x08268), P(0x0826c), P(0x08270), P(0x08274),
	P(0x08278), P(0x0827c), P(0x08284), P(0x08288), P(0x0828c),
	P(0x08294), P(0x08298), P(0x0829c), P(0x08300), P(0x08314),
	P(0x0831c), P(0x08328), P(0x0832c), P(0x08330), P(0x08334),
	P(0x08338), P(0x0833c), P(0x08340), P(0x08344), P(0x08348),
	P(0x0835c), P(0x08360), P(0x08364), P(0x08368), P(0x08370),
	P(0x08374), P(0x08378), P(0x0837c), P(0x08380), P(0x08384),
	P(0x08390), P(0x08394), P(0x08398), P(0x0839c), P(0x083a0),
	P(0x083a4), P(0x083a8), P(0x083ac), P(0x083b0), P(0x083b4),
	P(0x083b8), P(0x083bc), P(0x083c0), P(0x083c4), P(0x083c8),
	P(0x083cc), P(0x083d0), P(0x09800), P(0x09804), P(0x09808),
	P(0x0980c), P(0x09814), P(0x09818), P(0x0981c), P(0x09834),
	P(0x09838), P(0x0983c), P(0x09880), P(0x09884), P(0x098a4),
	P(0x098b0), P(0x098bc), P(0x098d0), P(0x098d4), P(0x098dc),
	P(0x098f0), P(0x098f4), P(0x09c04), P(0x09c08), P(0x09c0c),
	P(0x09c10), P(0x09c14), P(0x09c18), P(0x09c1c), P(0x09d00),
	P(0x09d04), P(0x09d08), P(0x09d0c), P(0x09d10), P(0x09d14),
	P(0x09d18), P(0x09d1c), P(0x09e08), P(0x09e24), P(0x09e28),
	P(0x09e30), P(0x09e34), P(0x09e38), P(0x09e40), P(0x09e4c),
	P(0x09e50), P(0x09fc0), P(0x09fc4), P(0x09fcc), P(0x0a20c),
	P(0x0a210), P(0x0a220), P(0x0a224), P(0x0a228), P(0x0a23c),
	P(0x0a244), P(0x0a2a0), P(0x0a2c0), P(0x0a2c8), P(0x0a2cc),
	P(0x0a2d4), P(0x0a2dc), P(0x0a2e0), P(0x0a2e4), P(0x0a2e8),
	P(0x0a2ec), P(0x0a2f0), P(0x0a2f4), P(0x0a2f8), P(0x0a344),
	P(0x0a34c), P(0x0a350), P(0x0a364), P(0x0a370), P(0x0a390),
	P(0x0a394), P(0x0a398), P(0x0a39c), P(0x0a3a0), P(0x0a3a4),
	P(0x0a3a8), P(0x0a3ac), P(0x0a3c0), P(0x0a3c4), P(0x0a3c8),
	P(0x0a3cc), P(0x0a3d0), P(0x0a3d4), P(0x0a3d8), P(0x0a3dc),
	P(0x0a3e0), P(0x0a3e4), P(0x0a3e8), P(0x0a3ec), P(0x0a3f0),
	P(0x0a3f4), P(0x0a3f8), P(0x0a3fc), P(0x0a400), P(0x0a404),
	P(0x0a408), P(0x0a40c), P(0x0a414), P(0x0a418), P(0x0a41c),
	P(0x0a420), P(0x0a424), P(0x0a428), P(0x0a42c), P(0x0a430),
	P(0x0a434), P(0x0a438), P(0x0a43c), P(0x0a440), P(0x0a444),
	P(0x0a448), P(0x0a44c), P(0x0a450), P(0x0a458), P(0x0a5c4),
	P(0x0a5c8), P(0x0a5cc), P(0x0a760), P(0x0a764), P(0x0a768),
	P(0x0a76c), P(0x0a770), P(0x0a774), P(0x0a778), P(0x0a780),
	P(0x0a7c0), P(0x0a7c4), P(0x0a7c8), P(0x0a7cc), P(0x0a7d0),
	P(0x0a7d4), P(0x0a7dc), P(0x16000), P(0x16004), P(0x16008),
	P(0x1600c), P(0x16040), P(0x16048), P(0x1604c), P(0x16050),
	P(0x16054), P(0x16080), P(0x16084), P(0x16088), P(0x1608c),
	P(0x16090), P(0x16098), P(0x160a0), P(0x160a4), P(0x160a8),
	P(0x160b4), P(0x160c0), P(0x160c4), P(0x160c8), P(0x160cc),
	P(0x160d0), P(0x16100), P(0x16104), P(0x16108), P(0x16144),
	P(0x16148), P(0x16180), P(0x16184), P(0x16188), P(0x1618c),
	P(0x16240), P(0x16244), P(0x16248), P(0x1624c), P(0x16280),
	P(0x16284), P(0x16288), P(0x1628c), P(0x16290), P(0x16380),
	P(0x16384), P(0x16388), P(0x1638c), P(0x16390), P(0x16394),
	P(0x16398), P(0x1639c), P(0x163a0), P(0x163a4), P(0x163a8),
	P(0x163ac), P(0x163b0), P(0x163b4), P(0x163b8), P(0x163bc),
	P(0x163c0), P(0x163c4), P(0x163c8), P(0x163cc), P(0x163d0),
	P(0x163d4), P(0x16c40), P(0x16c44)
};

static const uint32_t ar9485_1_0_cm_vals[] = {
	0x00a0c9c9, 0x00000004, 0x00000000, 0x00020085, 0x00000005,
	0x00000000, 0x00000000, 0x00000008, 0x00000010, 0x00000000,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f,
	0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,
	0x000fc78f, 0x0000000f, 0x00000000, 0x00000310, 0x00000020,
	0x00000000, 0x0000000f, 0x00000000, 0x02ff0000, 0x0e070605,
	0x0000000d, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2a800000, 0x06900168, 0x13881c20, 0x01f40000, 0x00252500,
	0x00a00000, 0x00400000, 0x00000000, 0xffffffff, 0x0000ffff,
	0x3f3f3f3f, 0x00000000, 0x00000000, 0x00000000, 0x00020000,
	0x00000000, 0x00000052, 0x00000000, 0x00000000, 0x000007ff,
	0x000000aa, 0x00003210, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x0000ffff, 0xffffffff,
	0x00000000, 0x00000000, 0x18486200, 0x33332210, 0x00000000,
	0x00020000, 0x00000000, 0x33332210, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00100000, 0x0010f400, 0x00000800, 0x0001e800,
	0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x00080922,
	0x9ca00010, 0xffffffff, 0x0000ffff, 0x00000000, 0x40000000,
	0x003e4180, 0x00000004, 0x0000002c, 0x0000002c, 0x000000ff,
	0x00000000, 0x00000000, 0x00000000, 0x00000140, 0x00000000,
	0x0000010d, 0x00000000, 0x00000007, 0x00000302, 0x00000700,
	0x00ff0000, 0x02400000, 0x000107ff, 0xa248105b, 0x008f0000,
	0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
	0x000000ff, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
	0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00000000,
	0x0000fa14, 0x000f0c00, 0x33332210, 0x33332210, 0x33332210,
	0x33332210, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000200, 0x000301ff, 0xafe68e30, 0xfd14e000, 0x9c0a8f6b,
	0x04800000, 0x9280c00a, 0x00000000, 0x00020028, 0x5f3ca3de,
	0x0108ecff, 0x14750600, 0x201fff00, 0x00001042, 0x00200400,
	0x52440bbe, 0x00000002, 0x004b6a8e, 0x00000820, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x03200000, 0x00000000,
	0x00000000, 0x00046384, 0x05b6b440, 0x00b6b440, 0xc080a333,
	0x40206c10, 0x009c4060, 0x1883800a, 0x01834061, 0x00c00400,
	0x00000000, 0x00000000, 0x0038233c, 0x990bb515, 0x0a6f0000,
	0x06336f77, 0x6af6532f, 0x0cc80c00, 0x0d261820, 0x00001004,
	0x00ff03f1, 0x80be4788, 0x0001efb5, 0x40000014, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x10002310, 0x00000000,
	0x0c000000, 0x00000001, 0x00000001, 0x00000000, 0x18c43433,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x0000a000, 0x00000000, 0x00000000, 0x00000001,
	0x00000444, 0x001f0e0f, 0x0075393f, 0xb79f6427, 0x00000000,
	0xaaaaaaaa, 0x3c466478, 0x20202020, 0x22222220, 0x20200020,
	0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
	0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x00000000,
	0x00000006, 0x0cdbd380, 0x000f0f01, 0x8fa91f01, 0x00000000,
	0x0e79e5c6, 0x00820820, 0x1ce739ce, 0x2d0011ce, 0x1ce739ce,
	0x000001ce, 0x1ce739ce, 0x000001ce, 0x1ce739ce, 0x1ce739ce,
	0x00000000, 0x00001801, 0x00000000, 0x00000000, 0x00000000,
	0x04000000, 0x00000001, 0x00010000, 0x00000000, 0x3fad9d74,
	0x0048060a, 0x00000637, 0x03020100, 0x09080504, 0x0d0c0b0a,
	0x13121110, 0x31301514, 0x35343332, 0x00000036, 0x00000838,
	0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x00000000,
	0x00000004, 0x00000001, 0x36db6db6, 0x6db6db40, 0x73800000,
	0x00000000, 0x7f80fff8, 0x6c92426e, 0x000f0278, 0x6db6db6c,
	0x6db60000, 0x00080000, 0x0e48048c, 0x14214514, 0x119f081e,
	0x24926490, 0xd28b3330, 0xc2108ffe, 0x812fc370, 0x423c8000,
	0x92480040, 0x006db6db, 0x0186db60, 0x6db6db6c, 0x6de6fbe0,
	0xf7dfcf3c, 0x04cb0001, 0xfff80015, 0x00080010, 0x01884080,
	0x00008040, 0x08453333, 0x18e82f01, 0x00000000, 0x00000000,
	0x08400000, 0x1bf90f00, 0x00000000, 0x00000000, 0x01000015,
	0x00d30000, 0x00318000, 0x50000000, 0x4b96210f, 0x00000000,
	0x00000000, 0x00800700, 0x00800700, 0x00800700, 0x00000000,
	0x00000000, 0x00000000, 0x00000001, 0x00000001, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x000000a0, 0x000c0000, 0x14021402, 0x00001402, 0x00000000,
	0x00000000, 0x1319c178, 0x10000000
};

static const struct athn_ini ar9485_1_0_ini = {
	nitems(ar9485_1_0_regs),
	ar9485_1_0_regs,
	NULL,	/* 2GHz only. */
#ifndef IEEE80211_NO_HT
	NULL,	/* 2GHz only. */
	ar9485_1_0_vals_2g40,
#endif
	ar9485_1_0_vals_2g20,
	nitems(ar9485_1_0_cm_regs),
	ar9485_1_0_cm_regs,
	ar9485_1_0_cm_vals
};

/*
 * AR9380 2.2 Tx gains.
 */
static const uint16_t ar9380_2_2_tx_gain_regs[] = {
	P(0x0a2dc), P(0x0a2e0), P(0x0a2e4), P(0x0a2e8), P(0x0a410),
	P(0x0a500), P(0x0a504), P(0x0a508), P(0x0a50c), P(0x0a510),
	P(0x0a514), P(0x0a518), P(0x0a51c), P(0x0a520), P(0x0a524),
	P(0x0a528), P(0x0a52c), P(0x0a530), P(0x0a534), P(0x0a538),
	P(0x0a53c), P(0x0a540), P(0x0a544), P(0x0a548), P(0x0a54c),
	P(0x0a550), P(0x0a554), P(0x0a558), P(0x0a55c), P(0x0a560),
	P(0x0a564), P(0x0a568), P(0x0a56c), P(0x0a570), P(0x0a574),
	P(0x0a578), P(0x0a57c), P(0x0a580), P(0x0a584), P(0x0a588),
	P(0x0a58c), P(0x0a590), P(0x0a594), P(0x0a598), P(0x0a59c),
	P(0x0a5a0), P(0x0a5a4), P(0x0a5a8), P(0x0a5ac), P(0x0a5b0),
	P(0x0a5b4), P(0x0a5b8), P(0x0a5bc), P(0x0a5c0), P(0x0a5c4),
	P(0x0a5c8), P(0x0a5cc), P(0x0a5d0), P(0x0a5d4), P(0x0a5d8),
	P(0x0a5dc), P(0x0a5e0), P(0x0a5e4), P(0x0a5e8), P(0x0a5ec),
	P(0x0a5f0), P(0x0a5f4), P(0x0a5f8), P(0x0a5fc), P(0x0a600),
	P(0x0a604), P(0x0a608), P(0x0a60c), P(0x0a610), P(0x0a614),
	P(0x0a618), P(0x0a61c), P(0x0a620), P(0x0a624), P(0x0a628),
	P(0x0a62c), P(0x0a630), P(0x0a634), P(0x0a638), P(0x0a63c),
	P(0x0b2dc), P(0x0b2e0), P(0x0b2e4), P(0x0b2e8), P(0x0c2dc),
	P(0x0c2e0), P(0x0c2e4), P(0x0c2e8), P(0x16044), P(0x16048),
	P(0x16068), P(0x16444), P(0x16448), P(0x16468), P(0x16844),
	P(0x16848), P(0x16868)
};

static const uint32_t ar9380_2_2_tx_gain_vals_5g[] = {
	0x00033800, 0x0003c000, 0x03fc0000, 0x00000000, 0x000050d9,
	0x00000000, 0x06000003, 0x0a000020, 0x10000023, 0x16000220,
	0x1c000223, 0x21002220, 0x27002223, 0x2b022220, 0x2f022222,
	0x34022225, 0x3a02222a, 0x3e02222c, 0x4202242a, 0x4702244a,
	0x4b02244c, 0x4e02246c, 0x52022470, 0x55022490, 0x59022492,
	0x5d022692, 0x61022892, 0x65024890, 0x69024892, 0x6e024c92,
	0x74026e92, 0x74026e92, 0x74026e92, 0x74026e92, 0x74026e92,
	0x74026e92, 0x74026e92, 0x00800000, 0x06800003, 0x0a800020,
	0x10800023, 0x16800220, 0x1c800223, 0x21802220, 0x27802223,
	0x2b822220, 0x2f822222, 0x34822225, 0x3a82222a, 0x3e82222c,
	0x4282242a, 0x4782244a, 0x4b82244c, 0x4e82246c, 0x52822470,
	0x55822490, 0x59822492, 0x5d822692, 0x61822892, 0x65824890,
	0x69824892, 0x6e824c92, 0x74826e92, 0x74826e92, 0x74826e92,
	0x74826e92, 0x74826e92, 0x74826e92, 0x74826e92, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02004000,
	0x02004801, 0x02808a02, 0x0380ce03, 0x04411104, 0x04411104,
	0x04411104, 0x04411104, 0x04411104, 0x04411104, 0x04411104,
	0x00033800, 0x0003c000, 0x03fc0000, 0x00000000, 0x00033800,
	0x0003c000, 0x03fc0000, 0x00000000, 0x012492d4, 0x62480001,
	0x6db6db6c, 0x012492d4, 0x62480001, 0x6db6db6c, 0x012492d4,
	0x62480001, 0x6db6db6c
};

static const uint32_t ar9380_2_2_tx_gain_vals_2g[] = {
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x000050d9,
	0x00000000, 0x04000002, 0x08000004, 0x0b000200, 0x0f000202,
	0x12000400, 0x16000402, 0x19000404, 0x1c000603, 0x21000a02,
	0x25000a04, 0x28000a20, 0x2c000e20, 0x30000e22, 0x34000e24,
	0x38001640, 0x3c001660, 0x3f001861, 0x43001a81, 0x47001a83,
	0x4a001c84, 0x4e001ce3, 0x52001ce5, 0x56001ce9, 0x5a001ceb,
	0x5d001eec, 0x5d001eec, 0x5d001eec, 0x5d001eec, 0x5d001eec,
	0x5d001eec, 0x5d001eec, 0x00800000, 0x04800002, 0x08800004,
	0x0b800200, 0x0f800202, 0x12800400, 0x16800402, 0x19800404,
	0x1c800603, 0x21800a02, 0x25800a04, 0x28800a20, 0x2c800e20,
	0x30800e22, 0x34800e24, 0x38801640, 0x3c801660, 0x3f801861,
	0x43801a81, 0x47801a83, 0x4a801c84, 0x4e801ce3, 0x52801ce5,
	0x56801ce9, 0x5a801ceb, 0x5d801eec, 0x5d801eec, 0x5d801eec,
	0x5d801eec, 0x5d801eec, 0x5d801eec, 0x5d801eec, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01404000,
	0x01404501, 0x02008501, 0x0280ca03, 0x03010c04, 0x04014c04,
	0x04015005, 0x04015005, 0x04015005, 0x04015005, 0x04015005,
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x00637800,
	0x03838000, 0x03fc0000, 0x00000000, 0x012492d4, 0x62480001,
	0x6db6db6c, 0x012492d4, 0x62480001, 0x6db6db6c, 0x012492d4,
	0x62480001, 0x6db6db6c
};

static const struct athn_gain ar9380_2_2_tx_gain = {
	nitems(ar9380_2_2_tx_gain_regs),
	ar9380_2_2_tx_gain_regs,
	ar9380_2_2_tx_gain_vals_5g,
	ar9380_2_2_tx_gain_vals_2g
};

/*
 * AR9380 2.2 high ob/db Tx gains.
 */
static const uint32_t ar9380_2_2_tx_gain_high_ob_db_vals_5g[] = {
	0x01feee00, 0x0000f000, 0x01ff0000, 0x00000000, 0x000050d8,
	0x00002220, 0x04002222, 0x09002421, 0x0d002621, 0x13004620,
	0x19004a20, 0x1d004e20, 0x21005420, 0x26005e20, 0x2b005e40,
	0x2f005e42, 0x33005e44, 0x38005e65, 0x3c005e69, 0x40005e6b,
	0x44005e6d, 0x49005e72, 0x4e005eb2, 0x53005f12, 0x59025eb2,
	0x5e025f12, 0x61027f12, 0x6702bf12, 0x6b02bf14, 0x6f02bf16,
	0x6f02bf16, 0x6f02bf16, 0x6f02bf16, 0x6f02bf16, 0x6f02bf16,
	0x6f02bf16, 0x6f02bf16, 0x00802220, 0x04802222, 0x09802421,
	0x0d802621, 0x13804620, 0x19804a20, 0x1d804e20, 0x21805420,
	0x26805e20, 0x2b805e40, 0x2f805e42, 0x33805e44, 0x38805e65,
	0x3c805e69, 0x40805e6b, 0x44805e6d, 0x49805e72, 0x4e805eb2,
	0x53805f12, 0x59825eb2, 0x5e825f12, 0x61827f12, 0x6782bf12,
	0x6b82bf14, 0x6f82bf16, 0x6f82bf16, 0x6f82bf16, 0x6f82bf16,
	0x6f82bf16, 0x6f82bf16, 0x6f82bf16, 0x6f82bf16, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00804000, 0x00804201,
	0x0280c802, 0x0280ca03, 0x04c15104, 0x04c15305, 0x04c15305,
	0x04c15305, 0x04c15305, 0x04c15305, 0x04c15305, 0x04c15305,
	0x01feee00, 0x0000f000, 0x01ff0000, 0x00000000, 0x01feee00,
	0x0000f000, 0x01ff0000, 0x00000000, 0x056db2e4, 0x8e480001,
	0x6db6db6c, 0x056db2e4, 0x8e480001, 0x6db6db6c, 0x056db2e4,
	0x8e480001, 0x6db6db6c
};

static const uint32_t ar9380_2_2_tx_gain_high_ob_db_vals_2g[] = {
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x000050d9,
	0x00000000, 0x04000002, 0x08000004, 0x0b000200, 0x0f000202,
	0x11000400, 0x15000402, 0x19000404, 0x1b000603, 0x1f000a02,
	0x23000a04, 0x26000a20, 0x2a000e20, 0x2e000e22, 0x31000e24,
	0x34001640, 0x38001660, 0x3b001861, 0x3e001a81, 0x42001a83,
	0x44001c84, 0x48001ce3, 0x4c001ce5, 0x50001ce9, 0x54001ceb,
	0x56001eec, 0x56001eec, 0x56001eec, 0x56001eec, 0x56001eec,
	0x56001eec, 0x56001eec, 0x00800000, 0x04800002, 0x08800004,
	0x0b800200, 0x0f800202, 0x11800400, 0x15800402, 0x19800404,
	0x1b800603, 0x1f800a02, 0x23800a04, 0x26800a20, 0x2a800e20,
	0x2e800e22, 0x31800e24, 0x34801640, 0x38801660, 0x3b801861,
	0x3e801a81, 0x42801a83, 0x44801c84, 0x48801ce3, 0x4c801ce5,
	0x50801ce9, 0x54801ceb, 0x56801eec, 0x56801eec, 0x56801eec,
	0x56801eec, 0x56801eec, 0x56801eec, 0x56801eec, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01404000,
	0x01404501, 0x02008501, 0x0280ca03, 0x03010c04, 0x04014c04,
	0x04015005, 0x04015005, 0x04015005, 0x04015005, 0x04015005,
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x00637800,
	0x03838000, 0x03fc0000, 0x00000000, 0x056db2e4, 0x8e480001,
	0x6db6db6c, 0x056db2e4, 0x8e480001, 0x6db6db6c, 0x056db2e4,
	0x8e480001, 0x6db6db6c
};

static const struct athn_gain ar9380_2_2_tx_gain_high_ob_db = {
	nitems(ar9380_2_2_tx_gain_regs),
	ar9380_2_2_tx_gain_regs,
	ar9380_2_2_tx_gain_high_ob_db_vals_5g,
	ar9380_2_2_tx_gain_high_ob_db_vals_2g
};

/*
 * AR9380 2.2 low ob/db Tx gains.
 */
static const uint32_t ar9380_2_2_tx_gain_low_ob_db_vals_5g[] = {
	0x0380c7fc, 0x0000f800, 0x03ff0000, 0x00000000, 0x000050d9,
	0x00000000, 0x06000003, 0x0a000020, 0x10000023, 0x16000220,
	0x1c000223, 0x21002220, 0x27002223, 0x2b022220, 0x2f022222,
	0x34022225, 0x3a02222a, 0x3e02222c, 0x4202242a, 0x4702244a,
	0x4b02244c, 0x4e02246c, 0x5302266c, 0x5702286c, 0x5c02486b,
	0x61024a6c, 0x66026a6c, 0x6b026e6c, 0x7002708c, 0x7302b08a,
	0x7702b08c, 0x7702b08c, 0x7702b08c, 0x7702b08c, 0x7702b08c,
	0x7702b08c, 0x7702b08c, 0x00800000, 0x06800003, 0x0a800020,
	0x10800023, 0x16800220, 0x1c800223, 0x21802220, 0x27802223,
	0x2b822220, 0x2f822222, 0x34822225, 0x3a82222a, 0x3e82222c,
	0x4282242a, 0x4782244a, 0x4b82244c, 0x4e82246c, 0x5382266c,
	0x5782286c, 0x5c82486b, 0x61824a6c, 0x66826a6c, 0x6b826e6c,
	0x7082708c, 0x7382b08a, 0x7782b08c, 0x7782b08c, 0x7782b08c,
	0x7782b08c, 0x7782b08c, 0x7782b08c, 0x7782b08c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01404000,
	0x01404501, 0x02008802, 0x0300cc03, 0x0300cc03, 0x0300cc03,
	0x03810c03, 0x03810e04, 0x03810e04, 0x03810e04, 0x03810e04,
	0x0380c7fc, 0x0000f800, 0x03ff0000, 0x00000000, 0x0380c7fc,
	0x0000f800, 0x03ff0000, 0x00000000, 0x012492d4, 0x66480001,
	0x6db6db6c, 0x012492d4, 0x66480001, 0x6db6db6c, 0x012492d4,
	0x66480001, 0x6db6db6c
};

static const uint32_t ar9380_2_2_tx_gain_low_ob_db_vals_2g[] = {
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x000050d9,
	0x00000000, 0x04000002, 0x08000004, 0x0b000200, 0x0f000202,
	0x12000400, 0x16000402, 0x19000404, 0x1c000603, 0x21000a02,
	0x25000a04, 0x28000a20, 0x2c000e20, 0x30000e22, 0x34000e24,
	0x38001640, 0x3c001660, 0x3f001861, 0x43001a81, 0x47001a83,
	0x4a001c84, 0x4e001ce3, 0x52001ce5, 0x56001ce9, 0x5a001ceb,
	0x5d001eec, 0x5d001eec, 0x5d001eec, 0x5d001eec, 0x5d001eec,
	0x5d001eec, 0x5d001eec, 0x00800000, 0x04800002, 0x08800004,
	0x0b800200, 0x0f800202, 0x12800400, 0x16800402, 0x19800404,
	0x1c800603, 0x21800a02, 0x25800a04, 0x28800a20, 0x2c800e20,
	0x30800e22, 0x34800e24, 0x38801640, 0x3c801660, 0x3f801861,
	0x43801a81, 0x47801a83, 0x4a801c84, 0x4e801ce3, 0x52801ce5,
	0x56801ce9, 0x5a801ceb, 0x5d801eec, 0x5d801eec, 0x5d801eec,
	0x5d801eec, 0x5d801eec, 0x5d801eec, 0x5d801eec, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01404000,
	0x01404501, 0x02008501, 0x0280ca03, 0x03010c04, 0x04014c04,
	0x04015005, 0x04015005, 0x04015005, 0x04015005, 0x04015005,
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x00637800,
	0x03838000, 0x03fc0000, 0x00000000, 0x012492d4, 0x66480001,
	0x6db6db6c, 0x012492d4, 0x66480001, 0x6db6db6c, 0x012492d4,
	0x66480001, 0x6db6db6c
};

static const struct athn_gain ar9380_2_2_tx_gain_low_ob_db = {
	nitems(ar9380_2_2_tx_gain_regs),
	ar9380_2_2_tx_gain_regs,
	ar9380_2_2_tx_gain_low_ob_db_vals_5g,
	ar9380_2_2_tx_gain_low_ob_db_vals_2g
};

/*
 * AR9380 2.2 high power Tx gains.
 */
static const uint32_t ar9380_2_2_tx_gain_high_power_vals_5g[] = {
	0x0380c7fc, 0x0000f800, 0x03ff0000, 0x00000000, 0x000050d8,
	0x00002220, 0x04002222, 0x09002421, 0x0d002621, 0x13004620,
	0x19004a20, 0x1d004e20, 0x21005420, 0x26005e20, 0x2b005e40,
	0x2f005e42, 0x33005e44, 0x38005e65, 0x3c005e69, 0x40005e6b,
	0x44005e6d, 0x49005e72, 0x4e005eb2, 0x53005f12, 0x59025eb2,
	0x5e025f12, 0x61027f12, 0x6702bf12, 0x6b02bf14, 0x6f02bf16,
	0x6f02bf16, 0x6f02bf16, 0x6f02bf16, 0x6f02bf16, 0x6f02bf16,
	0x6f02bf16, 0x6f02bf16, 0x00802220, 0x04802222, 0x09802421,
	0x0d802621, 0x13804620, 0x19804a20, 0x1d804e20, 0x21805420,
	0x26805e20, 0x2b805e40, 0x2f805e42, 0x33805e44, 0x38805e65,
	0x3c805e69, 0x40805e6b, 0x44805e6d, 0x49805e72, 0x4e805eb2,
	0x53805f12, 0x59825eb2, 0x5e825f12, 0x61827f12, 0x6782bf12,
	0x6b82bf14, 0x6f82bf16, 0x6f82bf16, 0x6f82bf16, 0x6f82bf16,
	0x6f82bf16, 0x6f82bf16, 0x6f82bf16, 0x6f82bf16, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00804000, 0x00804201,
	0x0280c802, 0x0280ca03, 0x04c15104, 0x04c15305, 0x04c15305,
	0x04c15305, 0x04c15305, 0x04c15305, 0x04c15305, 0x04c15305,
	0x0380c7fc, 0x0000f800, 0x03ff0000, 0x00000000, 0x0380c7fc,
	0x0000f800, 0x03ff0000, 0x00000000, 0x056db2e6, 0xae480001,
	0x6eb6db6c, 0x056db2e6, 0xae480001, 0x6eb6db6c, 0x056db2e6,
	0xae480001, 0x6eb6db6c
};

static const uint32_t ar9380_2_2_tx_gain_high_power_vals_2g[] = {
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x000050d9,
	0x00000000, 0x04000002, 0x08000004, 0x0b000200, 0x0f000202,
	0x11000400, 0x15000402, 0x19000404, 0x1b000603, 0x1f000a02,
	0x23000a04, 0x26000a20, 0x2a000e20, 0x2e000e22, 0x31000e24,
	0x34001640, 0x38001660, 0x3b001861, 0x3e001a81, 0x42001a83,
	0x44001c84, 0x48001ce3, 0x4c001ce5, 0x50001ce9, 0x54001ceb,
	0x56001eec, 0x56001eec, 0x56001eec, 0x56001eec, 0x56001eec,
	0x56001eec, 0x56001eec, 0x00800000, 0x04800002, 0x08800004,
	0x0b800200, 0x0f800202, 0x11800400, 0x15800402, 0x19800404,
	0x1b800603, 0x1f800a02, 0x23800a04, 0x26800a20, 0x2a800e20,
	0x2e800e22, 0x31800e24, 0x34801640, 0x38801660, 0x3b801861,
	0x3e801a81, 0x42801a83, 0x44801c84, 0x48801ce3, 0x4c801ce5,
	0x50801ce9, 0x54801ceb, 0x56801eec, 0x56801eec, 0x56801eec,
	0x56801eec, 0x56801eec, 0x56801eec, 0x56801eec, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01404000,
	0x01404501, 0x02008501, 0x0280ca03, 0x03010c04, 0x04014c04,
	0x04015005, 0x04015005, 0x04015005, 0x04015005, 0x04015005,
	0x00637800, 0x03838000, 0x03fc0000, 0x00000000, 0x00637800,
	0x03838000, 0x03fc0000, 0x00000000, 0x056db2e6, 0xae480001,
	0x6eb6db6c, 0x056db2e6, 0xae480001, 0x6eb6db6c, 0x056db2e6,
	0xae480001, 0x6eb6db6c
};

static const struct athn_gain ar9380_2_2_tx_gain_high_power = {
	nitems(ar9380_2_2_tx_gain_regs),
	ar9380_2_2_tx_gain_regs,
	ar9380_2_2_tx_gain_high_power_vals_5g,
	ar9380_2_2_tx_gain_high_power_vals_2g
};

/*
 * AR9485 1.0 Tx gains.
 */
static const uint16_t ar9485_1_0_tx_gain_regs[] = {
	P(0x0a410), P(0x0a500), P(0x0a504), P(0x0a508), P(0x0a50c),
	P(0x0a510), P(0x0a514), P(0x0a518), P(0x0a51c), P(0x0a520),
	P(0x0a524), P(0x0a528), P(0x0a52c), P(0x0a530), P(0x0a534),
	P(0x0a538), P(0x0a53c), P(0x0a540), P(0x0a544), P(0x0a548),
	P(0x0a54c), P(0x0a550), P(0x0a554), P(0x0a558), P(0x0a55c),
	P(0x0a560), P(0x0a564), P(0x0a568), P(0x0a56c), P(0x0a570),
	P(0x0a574), P(0x0a578), P(0x0a57c), P(0x16044)
};

static const uint32_t ar9485_1_0_tx_gain_vals_2g[] = {
	0x000050d8, 0x00000000, 0x04000002, 0x08000004, 0x0d000200,
	0x11000202, 0x15000400, 0x19000402, 0x1d000404, 0x21000603,
	0x25000605, 0x2a000a03, 0x2c000a04, 0x2e000a20, 0x34000e20,
	0x38000e22, 0x3c000e24, 0x40000e26, 0x43001640, 0x46001660,
	0x49001861, 0x4c001a81, 0x4f001a83, 0x54001c85, 0x58001ce5,
	0x5b001ce9, 0x60001eeb, 0x60001eeb, 0x60001eeb, 0x60001eeb,
	0x60001eeb, 0x60001eeb, 0x60001eeb, 0x05b6b2db
};

static const struct athn_gain ar9485_1_0_tx_gain = {
	nitems(ar9485_1_0_tx_gain_regs),
	ar9485_1_0_tx_gain_regs,
	NULL,	/* 2GHz only. */
	ar9485_1_0_tx_gain_vals_2g
};

/*
 * AR9380 2.2 Rx gains.
 */
static const uint16_t ar9380_2_2_rx_gain_regs[] = {
	P(0x0a000), P(0x0a004), P(0x0a008), P(0x0a00c), P(0x0a010),
	P(0x0a014), P(0x0a018), P(0x0a01c), P(0x0a020), P(0x0a024),
	P(0x0a028), P(0x0a02c), P(0x0a030), P(0x0a034), P(0x0a038),
	P(0x0a03c), P(0x0a040), P(0x0a044), P(0x0a048), P(0x0a04c),
	P(0x0a050), P(0x0a054), P(0x0a058), P(0x0a05c), P(0x0a060),
	P(0x0a064), P(0x0a068), P(0x0a06c), P(0x0a070), P(0x0a074),
	P(0x0a078), P(0x0a07c), P(0x0a080), P(0x0a084), P(0x0a088),
	P(0x0a08c), P(0x0a090), P(0x0a094), P(0x0a098), P(0x0a09c),
	P(0x0a0a0), P(0x0a0a4), P(0x0a0a8), P(0x0a0ac), P(0x0a0b0),
	P(0x0a0b4), P(0x0a0b8), P(0x0a0bc), P(0x0a0c0), P(0x0a0c4),
	P(0x0a0c8), P(0x0a0cc), P(0x0a0d0), P(0x0a0d4), P(0x0a0d8),
	P(0x0a0dc), P(0x0a0e0), P(0x0a0e4), P(0x0a0e8), P(0x0a0ec),
	P(0x0a0f0), P(0x0a0f4), P(0x0a0f8), P(0x0a0fc), P(0x0a100),
	P(0x0a104), P(0x0a108), P(0x0a10c), P(0x0a110), P(0x0a114),
	P(0x0a118), P(0x0a11c), P(0x0a120), P(0x0a124), P(0x0a128),
	P(0x0a12c), P(0x0a130), P(0x0a134), P(0x0a138), P(0x0a13c),
	P(0x0a140), P(0x0a144), P(0x0a148), P(0x0a14c), P(0x0a150),
	P(0x0a154), P(0x0a158), P(0x0a15c), P(0x0a160), P(0x0a164),
	P(0x0a168), P(0x0a16c), P(0x0a170), P(0x0a174), P(0x0a178),
	P(0x0a17c), P(0x0a180), P(0x0a184), P(0x0a188), P(0x0a18c),
	P(0x0a190), P(0x0a194), P(0x0a198), P(0x0a19c), P(0x0a1a0),
	P(0x0a1a4), P(0x0a1a8), P(0x0a1ac), P(0x0a1b0), P(0x0a1b4),
	P(0x0a1b8), P(0x0a1bc), P(0x0a1c0), P(0x0a1c4), P(0x0a1c8),
	P(0x0a1cc), P(0x0a1d0), P(0x0a1d4), P(0x0a1d8), P(0x0a1dc),
	P(0x0a1e0), P(0x0a1e4), P(0x0a1e8), P(0x0a1ec), P(0x0a1f0),
	P(0x0a1f4), P(0x0a1f8), P(0x0a1fc), P(0x0b000), P(0x0b004),
	P(0x0b008), P(0x0b00c), P(0x0b010), P(0x0b014), P(0x0b018),
	P(0x0b01c), P(0x0b020), P(0x0b024), P(0x0b028), P(0x0b02c),
	P(0x0b030), P(0x0b034), P(0x0b038), P(0x0b03c), P(0x0b040),
	P(0x0b044), P(0x0b048), P(0x0b04c), P(0x0b050), P(0x0b054),
	P(0x0b058), P(0x0b05c), P(0x0b060), P(0x0b064), P(0x0b068),
	P(0x0b06c), P(0x0b070), P(0x0b074), P(0x0b078), P(0x0b07c),
	P(0x0b080), P(0x0b084), P(0x0b088), P(0x0b08c), P(0x0b090),
	P(0x0b094), P(0x0b098), P(0x0b09c), P(0x0b0a0), P(0x0b0a4),
	P(0x0b0a8), P(0x0b0ac), P(0x0b0b0), P(0x0b0b4), P(0x0b0b8),
	P(0x0b0bc), P(0x0b0c0), P(0x0b0c4), P(0x0b0c8), P(0x0b0cc),
	P(0x0b0d0), P(0x0b0d4), P(0x0b0d8), P(0x0b0dc), P(0x0b0e0),
	P(0x0b0e4), P(0x0b0e8), P(0x0b0ec), P(0x0b0f0), P(0x0b0f4),
	P(0x0b0f8), P(0x0b0fc), P(0x0b100), P(0x0b104), P(0x0b108),
	P(0x0b10c), P(0x0b110), P(0x0b114), P(0x0b118), P(0x0b11c),
	P(0x0b120), P(0x0b124), P(0x0b128), P(0x0b12c), P(0x0b130),
	P(0x0b134), P(0x0b138), P(0x0b13c), P(0x0b140), P(0x0b144),
	P(0x0b148), P(0x0b14c), P(0x0b150), P(0x0b154), P(0x0b158),
	P(0x0b15c), P(0x0b160), P(0x0b164), P(0x0b168), P(0x0b16c),
	P(0x0b170), P(0x0b174), P(0x0b178), P(0x0b17c), P(0x0b180),
	P(0x0b184), P(0x0b188), P(0x0b18c), P(0x0b190), P(0x0b194),
	P(0x0b198), P(0x0b19c), P(0x0b1a0), P(0x0b1a4), P(0x0b1a8),
	P(0x0b1ac), P(0x0b1b0), P(0x0b1b4), P(0x0b1b8), P(0x0b1bc),
	P(0x0b1c0), P(0x0b1c4), P(0x0b1c8), P(0x0b1cc), P(0x0b1d0),
	P(0x0b1d4), P(0x0b1d8), P(0x0b1dc), P(0x0b1e0), P(0x0b1e4),
	P(0x0b1e8), P(0x0b1ec), P(0x0b1f0), P(0x0b1f4), P(0x0b1f8),
	P(0x0b1fc)
};

static const uint32_t ar9380_2_2_rx_gain_vals[] = {
	0x00010000, 0x00030002, 0x00050004, 0x00810080, 0x00830082,
	0x01810180, 0x01830182, 0x01850184, 0x01890188, 0x018b018a,
	0x018d018c, 0x01910190, 0x01930192, 0x01950194, 0x038a0196,
	0x038c038b, 0x0390038d, 0x03920391, 0x03940393, 0x03960395,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x22222229, 0x1d1d1d1d, 0x1d1d1d1d,
	0x1d1d1d1d, 0x171d1d1d, 0x11111717, 0x00030311, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x001f0000, 0x01000101,
	0x011e011f, 0x011c011d, 0x02030204, 0x02010202, 0x021f0200,
	0x0302021e, 0x03000301, 0x031e031f, 0x0402031d, 0x04000401,
	0x041e041f, 0x0502041d, 0x05000501, 0x051e051f, 0x06010602,
	0x061f0600, 0x061d061e, 0x07020703, 0x07000701, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x001f0000, 0x01000101, 0x011e011f, 0x011c011d, 0x02030204,
	0x02010202, 0x021f0200, 0x0302021e, 0x03000301, 0x031e031f,
	0x0402031d, 0x04000401, 0x041e041f, 0x0502041d, 0x05000501,
	0x051e051f, 0x06010602, 0x061f0600, 0x061d061e, 0x07020703,
	0x07000701, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000396,
	0x00000396, 0x00000396, 0x00000196, 0x00010000, 0x00030002,
	0x00050004, 0x00810080, 0x00830082, 0x01810180, 0x01830182,
	0x01850184, 0x02810280, 0x02830282, 0x02850284, 0x02890288,
	0x028b028a, 0x0388028c, 0x038a0389, 0x038c038b, 0x0390038d,
	0x03920391, 0x03940393, 0x03960395, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2a2d2f32, 0x21232328, 0x19191c1e, 0x12141417, 0x07070e0e,
	0x03030305, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x003f0020, 0x00400041, 0x0140005f, 0x0160015f,
	0x017e017f, 0x02410242, 0x025f0240, 0x027f0260, 0x0341027e,
	0x035f0340, 0x037f0360, 0x04400441, 0x0460045f, 0x0541047f,
	0x055f0540, 0x057f0560, 0x06400641, 0x0660065f, 0x067e067f,
	0x07410742, 0x075f0740, 0x077f0760, 0x07800781, 0x07a0079f,
	0x07c107bf, 0x000007c0, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x003f0020, 0x00400041,
	0x0140005f, 0x0160015f, 0x017e017f, 0x02410242, 0x025f0240,
	0x027f0260, 0x0341027e, 0x035f0340, 0x037f0360, 0x04400441,
	0x0460045f, 0x0541047f, 0x055f0540, 0x057f0560, 0x06400641,
	0x0660065f, 0x067e067f, 0x07410742, 0x075f0740, 0x077f0760,
	0x07800781, 0x07a0079f, 0x07c107bf, 0x000007c0, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000396, 0x00000396, 0x00000396,
	0x00000196
};

static const struct athn_gain ar9380_2_2_rx_gain = {
	nitems(ar9380_2_2_rx_gain_regs),
	ar9380_2_2_rx_gain_regs,
	ar9380_2_2_rx_gain_vals,
	ar9380_2_2_rx_gain_vals
};

/*
 * AR9380 2.2 without external low-noise amplifier Rx gains.
 */
static const uint32_t ar9380_2_2_rx_gain_wo_xlna_vals[] = {
	0x00010000, 0x00030002, 0x00050004, 0x00810080, 0x00830082,
	0x01810180, 0x01830182, 0x01850184, 0x01890188, 0x018b018a,
	0x018d018c, 0x03820190, 0x03840383, 0x03880385, 0x038a0389,
	0x038c038b, 0x0390038d, 0x03920391, 0x03940393, 0x03960395,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x29292929, 0x29292929, 0x29292929,
	0x29292929, 0x22292929, 0x1d1d2222, 0x0c111117, 0x00030303,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x001f0000, 0x01000101,
	0x011e011f, 0x011c011d, 0x02030204, 0x02010202, 0x021f0200,
	0x0302021e, 0x03000301, 0x031e031f, 0x0402031d, 0x04000401,
	0x041e041f, 0x0502041d, 0x05000501, 0x051e051f, 0x06010602,
	0x061f0600, 0x061d061e, 0x07020703, 0x07000701, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x001f0000, 0x01000101, 0x011e011f, 0x011c011d, 0x02030204,
	0x02010202, 0x021f0200, 0x0302021e, 0x03000301, 0x031e031f,
	0x0402031d, 0x04000401, 0x041e041f, 0x0502041d, 0x05000501,
	0x051e051f, 0x06010602, 0x061f0600, 0x061d061e, 0x07020703,
	0x07000701, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000396,
	0x00000396, 0x00000396, 0x00000196, 0x00010000, 0x00030002,
	0x00050004, 0x00810080, 0x00830082, 0x01810180, 0x01830182,
	0x01850184, 0x02810280, 0x02830282, 0x02850284, 0x02890288,
	0x028b028a, 0x0388028c, 0x038a0389, 0x038c038b, 0x0390038d,
	0x03920391, 0x03940393, 0x03960395, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x32323232, 0x2f2f3232, 0x23282a2d, 0x1c1e2123, 0x14171919,
	0x0e0e1214, 0x03050707, 0x00030303, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x003f0020, 0x00400041, 0x0140005f, 0x0160015f,
	0x017e017f, 0x02410242, 0x025f0240, 0x027f0260, 0x0341027e,
	0x035f0340, 0x037f0360, 0x04400441, 0x0460045f, 0x0541047f,
	0x055f0540, 0x057f0560, 0x06400641, 0x0660065f, 0x067e067f,
	0x07410742, 0x075f0740, 0x077f0760, 0x07800781, 0x07a0079f,
	0x07c107bf, 0x000007c0, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x003f0020, 0x00400041,
	0x0140005f, 0x0160015f, 0x017e017f, 0x02410242, 0x025f0240,
	0x027f0260, 0x0341027e, 0x035f0340, 0x037f0360, 0x04400441,
	0x0460045f, 0x0541047f, 0x055f0540, 0x057f0560, 0x06400641,
	0x0660065f, 0x067e067f, 0x07410742, 0x075f0740, 0x077f0760,
	0x07800781, 0x07a0079f, 0x07c107bf, 0x000007c0, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000396, 0x00000396, 0x00000396,
	0x00000196
};

static const struct athn_gain ar9380_2_2_rx_gain_wo_xlna = {
	nitems(ar9380_2_2_rx_gain_regs),
	ar9380_2_2_rx_gain_regs,
	ar9380_2_2_rx_gain_wo_xlna_vals,
	ar9380_2_2_rx_gain_wo_xlna_vals
};

/*
 * AR9485 1.0 Rx gains.
 */
static const uint16_t ar9485_1_0_rx_gain_regs[] = {
	P(0x0a000), P(0x0a004), P(0x0a008), P(0x0a00c), P(0x0a010),
	P(0x0a014), P(0x0a018), P(0x0a01c), P(0x0a020), P(0x0a024),
	P(0x0a028), P(0x0a02c), P(0x0a030), P(0x0a034), P(0x0a038),
	P(0x0a03c), P(0x0a040), P(0x0a044), P(0x0a048), P(0x0a04c),
	P(0x0a050), P(0x0a054), P(0x0a058), P(0x0a05c), P(0x0a060),
	P(0x0a064), P(0x0a068), P(0x0a06c), P(0x0a070), P(0x0a074),
	P(0x0a078), P(0x0a07c), P(0x0a080), P(0x0a084), P(0x0a088),
	P(0x0a08c), P(0x0a090), P(0x0a094), P(0x0a098), P(0x0a09c),
	P(0x0a0a0), P(0x0a0a4), P(0x0a0a8), P(0x0a0ac), P(0x0a0b0),
	P(0x0a0b4), P(0x0a0b8), P(0x0a0bc), P(0x0a0c0), P(0x0a0c4),
	P(0x0a0c8), P(0x0a0cc), P(0x0a0d0), P(0x0a0d4), P(0x0a0d8),
	P(0x0a0dc), P(0x0a0e0), P(0x0a0e4), P(0x0a0e8), P(0x0a0ec),
	P(0x0a0f0), P(0x0a0f4), P(0x0a0f8), P(0x0a0fc), P(0x0a100),
	P(0x0a104), P(0x0a108), P(0x0a10c), P(0x0a110), P(0x0a114),
	P(0x0a118), P(0x0a11c), P(0x0a120), P(0x0a124), P(0x0a128),
	P(0x0a12c), P(0x0a130), P(0x0a134), P(0x0a138), P(0x0a13c),
	P(0x0a140), P(0x0a144), P(0x0a148), P(0x0a14c), P(0x0a150),
	P(0x0a154), P(0x0a158), P(0x0a15c), P(0x0a160), P(0x0a164),
	P(0x0a168), P(0x0a16c), P(0x0a170), P(0x0a174), P(0x0a178),
	P(0x0a17c), P(0x0a180), P(0x0a184), P(0x0a188), P(0x0a18c),
	P(0x0a190), P(0x0a194), P(0x0a198), P(0x0a19c), P(0x0a1a0),
	P(0x0a1a4), P(0x0a1a8), P(0x0a1ac), P(0x0a1b0), P(0x0a1b4),
	P(0x0a1b8), P(0x0a1bc), P(0x0a1c0), P(0x0a1c4), P(0x0a1c8),
	P(0x0a1cc), P(0x0a1d0), P(0x0a1d4), P(0x0a1d8), P(0x0a1dc),
	P(0x0a1e0), P(0x0a1e4), P(0x0a1e8), P(0x0a1ec), P(0x0a1f0),
	P(0x0a1f4), P(0x0a1f8), P(0x0a1fc)
};

static const uint32_t ar9485_1_0_rx_gain_vals[] = {
	0x00010000, 0x00030002, 0x00050004, 0x00810080, 0x01800082,
	0x01820181, 0x01840183, 0x01880185, 0x018a0189, 0x02850284,
	0x02890288, 0x03850384, 0x03890388, 0x038b038a, 0x038d038c,
	0x03910390, 0x03930392, 0x03950394, 0x00000396, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x28282828, 0x28282828, 0x28282828,
	0x28282828, 0x28282828, 0x21212128, 0x171c1c1c, 0x02020212,
	0x00000202, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x001f0000, 0x111f1100,
	0x111d111e, 0x111b111c, 0x22032204, 0x22012202, 0x221f2200,
	0x221d221e, 0x33013302, 0x331f3300, 0x4402331e, 0x44004401,
	0x441e441f, 0x55015502, 0x551f5500, 0x6602551e, 0x66006601,
	0x661e661f, 0x7703661d, 0x77017702, 0x00007700, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x001f0000, 0x111f1100, 0x111d111e, 0x111b111c, 0x22032204,
	0x22012202, 0x221f2200, 0x221d221e, 0x33013302, 0x331f3300,
	0x4402331e, 0x44004401, 0x441e441f, 0x55015502, 0x551f5500,
	0x6602551e, 0x66006601, 0x661e661f, 0x7703661d, 0x77017702,
	0x00007700, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000396,
	0x00000396, 0x00000396, 0x00000296
};

static const struct athn_gain ar9485_1_0_rx_gain = {
	nitems(ar9485_1_0_rx_gain_regs),
	ar9485_1_0_rx_gain_regs,
	NULL,	/* 2GHz only. */
	ar9485_1_0_rx_gain_vals
};

/*
 * Serializer/Deserializer programming.
 */
static const uint32_t ar9380_2_2_serdes_vals[] = {
	0x08212e5e,
	0x0008003b
};

static const struct athn_serdes ar9380_2_2_serdes = {
	nitems(ar9380_2_2_serdes_vals),
	ar9380_2_2_serdes_vals
};
